<?php
/**
 * Шаблон для отображения ленты продуктов в сайдбаре.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

$query_args['post_type'] = 'products';
$query_args['posts_per_page'] = $instance['posts_number'];
switch ($instance['order_by']) {
	case 'none' : break;
	case 'id_asc' : $query_args['orderby'] = 'ID'; $query_args['order'] = 'ASC'; break;
	case 'id_desc' : $query_args['orderby'] = 'ID'; $query_args['order'] = 'DESC'; break;
	case 'date_asc' : $query_args['orderby'] = 'date'; $query_args['order'] = 'ASC'; break;
	case 'date_desc' : $query_args['orderby'] = 'date'; $query_args['order'] = 'DESC'; break;
	case 'title_asc' : $query_args['orderby'] = 'title'; $query_args['order'] = 'ASC'; break;
	case 'title_desc' : $query_args['orderby'] = 'title'; $query_args['order'] = 'DESC'; break;
	default : $query_args['orderby'] = $instance['order_by'];
}
switch ($instance['filter']) {
	case 'category' :
		$tax_query[0]['taxonomy'] = 'catalog';
		$tax_query[0]['terms'] = trim($instance['selected_category']);
		$tax_query[0]['field'] = 'id';
		break;
	case 'categories' :
		$tax_query[0]['taxonomy'] = 'catalog';
		$tax_query[0]['terms'] = trim($instance['filter_categories']);
		$tax_query[0]['field'] = 'id';
		break;
	case 'manufacturers' :
		$tax_query[0]['taxonomy'] = 'manufacturers';
		$tax_query[0]['terms'] = trim($instance['filter_manufacturers']);
		$tax_query[0]['field'] = 'slug';
		break;
	case 'recent' :
		$product_id = get_the_ID();
		$tax_query[0]['taxonomy'] = 'catalog';
		$tax_query[0]['terms'] = wp_get_object_terms( $product_id, 'catalog', array( 'orderby' => 'count', 'fields' => 'ids' ) );
		$tax_query[0]['field'] = 'id';
		//$query_args['post__not_in'] = $product_id;
		break;
	default :  $tax_query[0]['taxonomy'] = 'catalog';
}
$query_args['tax_query'] = $tax_query;
$query_args['post__not_in'] = array( $product_id );
?>
					<div class="posts-widget">
						<?php if( $title ) { ?>

						<h3 class="widget-title"><?php echo $title; ?></h3>
						<?php } ?>

						<?php
						$query = new WP_Query( $query_args );
						if( $query->have_posts() ) {
						while( $query->have_posts() ) {
							$query->the_post();
						?>

						<div class="posts-widget-item clearfix">
							<?php if( $instance['display_featured_image'] && has_post_thumbnail( $query->post->ID ) ) {
								$attachment_id = get_post_thumbnail_id( $query->post->ID );
								$image_attributes = wp_get_attachment_image_src( $attachment_id );
								
							?>
							<div class="posts-widget-thumbnail" style="width:<?php echo $instance['featured_image_size']; ?>px; height:<?php echo $instance['featured_image_size']; ?>px; float:<?php echo $instance['featured_image_align']; ?>;">
								<a class="thumbnail" href="<?php echo get_permalink( $query->post->ID ); ?>" title="<?php echo $query->post->post_title; ?>">
									<img class="img-responsive" src="<?php echo $image_attributes[0]; ?>" alt="<?php echo $query->post->post_title; ?>">
								</a>
							</div>
							<?php } ?>
							<?php if( $instance['display_title'] ) { ?>
							<h4 class="posts-widget-title">
								<a href="<?php echo get_permalink($query->post->ID); ?>" rel="bookmark" title="<?php echo $query->post->post_title; ?>">
									<?php echo $query->post->post_title; ?>
								</a>
							</h4>
							<?php } ?>
							<?php if( $instance['display_content'] || $instance['display_read_more'] ) { ?>

							<div class="posts-widget-entry">
								<?php 
								if( $instance['display_content'] ) {
									$excerpt_length = $instance['excerpt_length'] ? $instance['excerpt_length'] : 16;

									if( $instance['content_type'] == 'the_content' || $query->post->post_excerpt == '' ) {
										$content = $this->shorten( $query->post->post_content, $excerpt_length );
									} else {
										$content = $this->shorten( $query->post->post_excerpt, $excerpt_length );
									}
									$content = $this->strip_shortcode_gallery( $content );
									$content = str_replace( ']]>', ']]&gt;', apply_filters( 'the_content', $content ) );
									echo $content;
								}

								if( $instance['display_read_more'] ) { ?>

									<a class="posts-widget-more text-primary pull-right" href="<?php the_permalink($query->post->ID) ?>" rel="bookmark" title="<?php echo $query->post->post_title; ?>">
										&nbsp;<?php _e( 'More', 'spiral' ); ?> &raquo;
									</a>
								<?php 
								} // endif
								?>

							</div>
							<?php
							} // endif
							?>
						</div>
						<?php
						} // endwhile haveposts
					} // endif haveposts
					wp_reset_postdata();
					?>

					</div>