<?php
/**
 * Шаблон для подвала записи
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

if( !function_exists(ancestors_list) ) {

	function ancestors_list() {
		// Место расположения
		$cat_ids = wp_get_post_categories( get_the_ID() );
		$cat_ids = array_reverse($cat_ids);
		foreach( $cat_ids as $cat_id ) {
			$cat = get_term($cat_id,'category');
			if( $cats != '' ) {
				$cats .= '<br>';
			}
			if( $cat_id == $term_id ) {
				$cats .= '<span class="active">';
				$cats .= $cat->name;
				$cats .= '</span>';
			} else {
				$cats .= '<a href="';
				$cats .= get_term_link( (int) $cat_id, 'category' );
				$cats .= '" title="' . __('More','spiral') . ': ' . $cat->name.'">';
				$cats .= $cat->name;
				$cats .= '</a>';
			}
		}
		if( $cats != '' ) {
			$cats = '<span class="pull-left text-left"><i class="fa fa-folder-open" aria-hidden="true"></i> ' . $cats . '</span>';
		}
		return $cats;
	}
}

if( !function_exists(tags_list) ) {

	function tags_list() {
		$post_tags = get_the_tags($post->ID);
		if ($post_tags) {
			$result_set = PHP_EOL . "\t\t\t\t" . '<div class="tag-line clearfix">' . PHP_EOL;
			foreach( $post_tags as $tag) {
				// Табуляция
				$result_set .= "\t\t\t\t\t";
				// Начало разметки для ссылки в виде кнопки
				$result_set .= '<a class="btn btn-default btn-sm" role="button" href="';
				// Урл тега
				$result_set .= get_tag_link($tag->term_id);
				
				// Заголовок
				$result_set .= '" title="';
				if( isset($tag->description) && $tag->description != '' ) {
					$result_set .= $tag->description;
				} else {
					$result_set .= __('All posts tagged','spiral') . ': ' . $tag->name;
				}
				// Конец разметки для ссылки
				$result_set .= '">';
				// Иконка
				$result_set .= '<i class="fa fa-tag" aria-hidden="true"></i>&nbsp;';
				// Имя тега
				$result_set .= '<span itemprop="articleSection">' . $tag->name . '</span>';
				// Количество записей у тега
				$result_set .= '<span class="badge">' . $tag->count . '</span> ';
				// Закрывающий тег ссылки
				$result_set .= '</a>';
				// Переход на новую строку
				$result_set .= PHP_EOL;
			}
			$result_set .= "\t\t\t\t" . '</div>' . PHP_EOL;
		}
		return $result_set;
	}
}
?>

						<footer class="clearfix entry-footer">
							<?php if( !is_single() ) { ?>

							<?php echo ancestors_list(); ?>

								<?php if( get_the_content() != '' ) { ?>

							<a itemprop="mainEntityOfPage" href="<?php the_permalink(); ?>" class="pull-right btn btn-info btn-sm"><i class="fa fa-eye fa-fw" aria-hidden="true"></i> <?php echo __('More','spiral'); ?></a>

								<?php } ?>

							<?php } else { ?>

							<?php echo tags_list(); ?>


							<div id="post-navigation" class="clearfix" itemscope itemtype="http://schema.org/SiteNavigationElement">
								<ul class="pager">
									<li class="previous"><?php previous_post_link( '%link', '<i class="fa fa-step-backward" aria-hidden="true"></i> %title' ); ?></li>
									<li class="next"><?php next_post_link( '%link', '%title <i class="fa fa-step-forward" aria-hidden="true"></i>' ); ?></li>
								</ul>
							</div>

							<?php } ?>
							
						</footer><!-- .post-meta -->