<?php
/**
 * Главное меню с формой поиска.
 *
 * @author veselka.ua
 * @version 0.2
 *
 * @package veselka_ua/themes
 */

require_once TEMPLATEPATH . '/view/navbar/_fix_type.php';
?>

		<!-- Static navbar -->
		<nav id="navbar-top-serch" class="<?php echo $class; ?>" itemscope itemtype="http://schema.org/SiteNavigationElement">
			<div class="container">
				<div class="row">

					<div class="navbar-header">
						<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-header" aria-expanded="true" aria-controls="navbar-header">
							<i class="fa fa-bars" aria-hidden="true"></i>
						</button>

						<?php
							// Для мобильных кнопка поиска с поповером формы поиска
							// Только если загружен объект вспомогательных кнопок
							if( (bool)get_option('common_help_buttons') ) {
						?>
						<a id="navbar-search-form" class="visible-xs-inline navbar-link pull-left" data-toggle="popover" data-target="#search-form-popover" data-content="<?php get_template_part( 'view/help_buttons/_search_form_compiled' ); ?>" title="<?php echo __('Site search','spiral'); ?>">
							<i class="fa fa-search fa-fw" aria-hidden="true"></i>
						</a>
						<?php
							}
						?>

						<?php
							// Разметка кнопки вызова списка телефонов
							get_template_part('view/navbar/_btn_phones'); 
						?>

						<form id="navbar-search" class="navbar-form navbar-left hidden-xs" role="search" action="<?php echo esc_url(home_url( '/' )); ?>">
							<div class="form-group">
								<span class="search-sign"></span>
								<input type="text" id="s" name="s" class="form-control">
								<input type="submit" id="searchsubmit" style="display: none;" value="Search">
							</div>
						</form>
					</div>

					<div id="navbar-header" class="navbar-collapse collapse">
					<?php
						$args = array(
							'theme_location' => 'top-bar-nav',
							'depth'		 => 3,
							'container'	=> false,
							'echo'		=>	true, // Для внедрения логотипа поменять - результат копируется в переменную
							'menu_class'	 => 'nav navbar-nav navbar-right',
							'fallback_cb'       => 'Bootstrap_Walker_Nav_Menu::fallback',
							'walker'	 => new Bootstrap_Walker_Nav_Menu()
						);
						wp_nav_menu($args);
					?>

					</div><!--/.navbar-collapse -->
	
				</div><!-- /.row -->
			</div><!-- /.container -->
		</nav>