<?php
/**
 * Пользовательское меню.
 *
 * @author veselka.ua
 * @version 0.5
 *
 * @package veselka_ua/themes
 */

//data-correction="+50" to <nav>

require_once TEMPLATEPATH . '/view/navbar/_fix_type.php';
?>

			<div class="fixed-nav-wrapper">
				<!-- navbar -->
				<nav id="stick-menu" class="<?php echo $class; ?> affix-add" data-correction="+50" itemscope itemtype="http://schema.org/SiteNavigationElement">
					<div class="container">

						<div class="navbar-header">

							<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-header" aria-expanded="true" aria-controls="navbar-header">
								<i class="fa fa-bars" aria-hidden="true"></i>
							</button>

							<span class="phone-btn-wrap hidden">
							<?php
								// Разметка кнопки вызова списка телефонов
								get_template_part('view/navbar/_btn_phone_xs'); 
							?>
							</span>

							<span class="email-btn-wrap hidden">
							<?php
								// Разметка кнопки вызова списка телефонов
								get_template_part('view/navbar/_btn_question'); 
							?>
							</span>

							<span class="logo-wrap hidden">
							<?php
								// Разметка логотипа
								get_template_part('view/navbar/_logo'); 
							?>
							</span>

							<span class="logo-phone-wrap hidden hidden-sm hidden-md hidden-lg">
							<?php
							// Контактный телефон
							if( has_action( 'one_phone_nav_link' ) ) {
								do_action( 'one_phone_nav_link' );
							}
							?>
							</span>

						</div>

						<div class="phone-wrap hidden">
						<?php
							// Контактный телефон
							if( has_action( 'one_phone_nav' ) ) {
								do_action( 'one_phone_nav' );
							}
						?>
						</div>

						<div id="navbar-header" class="navbar-collapse collapse">
						<?php
							$args = array(
								'theme_location'	=>	'top-bar-nav',
								'depth'				=>	3,
								'container'			=>	false,
								'echo'				=>	true, // Для внедрения логотипа поменять - результат копируется в переменную
								'menu_class'		=>	'nav navbar-nav',
								'fallback_cb'		=>	'Bootstrap_Walker_Nav_Menu::fallback',
								'walker'			=>	new Bootstrap_Walker_Nav_Menu()
							);
							wp_nav_menu($args);
						?>
						</div><!--/.navbar-collapse -->

					</div><!-- /.container -->
				</nav>
			</div><!-- /.fixed-nav-wrapper -->
