<?php
/**
 * Выбор загружаемого вторичного верхнего меню сайта.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

	// Выбор загружаемого меню
	if( is_page_template('templates/home.php') ) {
		$veselka_navbar = get_option('var_navbar_second');
		if( !(bool)$veselka_navbar || $veselka_navbar == '' ) {
			$veselka_navbar = 'nav-empty';
		}
	} else {
		$veselka_navbar = get_option('var_navbar_second_inner');
		if( !(bool)$veselka_navbar || $veselka_navbar == '' ) {
			$veselka_navbar = 'top-nav-second';
		}
	}

	// Удаление суффикса указывающего на тип меню
	$type = explode('-', $veselka_navbar);
	if( in_array( end($type), ['default','inverse'] ) ) {
		$veselka_navbar = str_replace( '-'.end($type), '', $veselka_navbar );
	}

	// Подключение меню
	get_template_part('view/navbar/'. $veselka_navbar); 
?>