<?php
/**
 * Выбор загружаемого верхнего меню сайта.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

	// Выбор загружаемого меню
	if( is_page_template('templates/home.php') ) {
		$veselka_navbar = get_option('var_navbar');
	} elseif( is_page_template('landing.php') ) {
		$veselka_navbar = get_option('var_navbar_landing');
	} else {
		$veselka_navbar = get_option('var_navbar_inner');
	}

	// Меню по умолчанию
	if( !(bool)$veselka_navbar || $veselka_navbar == '' ) {
		$veselka_navbar = 'top-nav';
	}

	// Удаление суффикса указывающего на тип меню
	$type = explode('-', $veselka_navbar);
	if( in_array( end($type), ['default','inverse'] ) ) {
		$veselka_navbar = str_replace( '-'.end($type), '', $veselka_navbar );
	}

	// Подключение меню
	get_template_part('view/navbar/'. $veselka_navbar); 
?>