<?php
/**
 * Вывод слайдера.
 * 
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

$homepage = get_page_by_path( 'homepage' );
if( $homepage ) {
	// Поиск дочерних страниц
	$args = [
		'post_parent'	=>	$homepage->ID,
		'post_type'		=>	'page',
		'numberposts'	=>	-1,
		'post_status'	=>	'private',
		'orderby'		=>	'menu_order',
		'order'			=>	'ASC'
	];
	$slides = get_children( $args );

	if( $slides ) {
?>

		<!-- Carousel -->
		<div id="homepage-carousel" class="responsive-carousel">
			<div class="owl-carousel">

<?php
		foreach($slides as $page_id => $slide_page) {
		$large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($slide_page->ID), 'full');
?>

				<div class="homepage-slide clearfix" style="background-image: url(<?php echo $large_image_url[0];?>);">
					<div class="container">
						<div class="row">
							<div class="col-sm-6 col-sm-offset-6">
								<div class="slide-title"><?php echo $slide_page->posst_title;?></div>

								<div class="slide-content"><?php echo $slide_page->post_content;?></div>
								<div class="slide-more">
									<a class="pull-right btn btn-info btn-lg" href="<?php echo get_post_meta($slide_page->ID, 'slider_url', true); ?>" title="<?php echo $slide_page->post_title;?>"><?php echo __('More', 'spiral'); ?>&nbsp;<i class="fa fa-angle-right fa-fw" aria-hidden="true"></i></a>
								</div>

							</div>
						</div><!-- /.row -->
					</div><!-- /.container -->
				</div><!-- /.homepage-slide -->

<?php
		} // endforeach
?>

			</div><!-- /#homepage-carousel -->
		</div><!-- /.responsive-carousel -->

<?php
	}
}
?>

		<div class="container">
			<div class="row">