<?php
/**
 * Шапка сайта с телефонами.
 *
 * @author veselka.ua
 * @version 0.3
 *
 * @package veselka_ua/themes
 */

?>

<?php get_template_part( 'view/navbar/_select_top' ); ?>

		<header id="masthead-shopping" class="container affix-add" itemscope itemtype="http://schema.org/WPHeader">
			<?php get_template_part( 'view/header/_meta_headline' ); ?>
			<div class="masthead clearfix">
				<div class="row">
					<div id="site-title" class="col-sm-3 col-md-3 col-lg-3">
						<?php
							if( !is_home() && !is_front_page() ) {
						?>
							<a id="logo" href="<?php echo get_home_url(); ?>" title="<?php bloginfo('name'); ?> - <?php bloginfo('description'); ?>">
								<img class="img-responsive" src="<?php echo TEMPLATE_URL; ?>/img/logo.png" alt="<?php bloginfo('name'); ?> - <?php bloginfo('description'); ?>">
							</a>
						<?php
							} else {
						?>
							<span id="logo">
								<img class="img-responsive" src="<?php echo TEMPLATE_URL; ?>/img/logo.png" alt="<?php bloginfo('name'); ?> - <?php bloginfo('description'); ?>">
							</span>
						<?php
							}
						?>
					</div><!-- /#site-title -->

					<div class="head-info head-phone col-sm-4 col-md-3 col-lg-3">
					<?php
						if( has_action( 'all_phones_list_two_columns' ) ) {
							do_action( 'all_phones_list_two_columns' );
						}
					?>
					</div><!-- /.head-phone -->


					<?php
					$veselka_address = get_option('public_address');
					if( $veselka_address ) {
					?>

					<div class="head-info head-address hidden-sm col-md-3 col-lg-3">
						<a href="<?php echo esc_url( get_permalink( get_page_by_path('contacts') ) ); ?>#map-contacts" title="<?php bloginfo('name'); ?>">
							<span class="icon-block text-primary"><i class="fa fa-map-marker fa-fw" aria-hidden="true"></i></span>
							<span class="top-block text-gray-dark"><?php echo $veselka_address; ?></span>
							<span class="bottom-block text-gray-light"><?php echo get_option('public_poatal_code') . ', ' . get_option('public_localization'); ?></span>
						</a>
					</div><!-- /.head-address -->
					<?php
					}
					?>

					<?php
						$shop_url = get_option('siteurl');
						$shop_title = get_bloginfo('name') . ' - ' . get_bloginfo('description');
						if( is_tax() ) {
							// Вычисление местоположения
							$queried_object = get_queried_object();
							$term_id = $queried_object->term_id;
							$tax_data = get_option("taxonomy_$term_id");
							// Есть ли ссылка на внешний каталог
							if( $tax_data['cat_external'] != '' ) {
								$shop_url = $tax_data['cat_external'];
								$shop_title = $queried_object->name;
							}
						}
					?>

					<!--noindex-->
					<div class="head-info head-cart col-sm-5 col-md-3 col-lg-3">
						<a rel="nofollow" class="external-url" href="#seco-pack" target="_blank" data-shop-slug="<?php echo $shop_url; ?>" title="<?php echo $shop_title; ?>">
							<span class="icon-block text-primary hidden-md"><i class="fa fa-shopping-cart fa-fw" aria-hidden="true"></i></span>
							<span class="top-block text-uppercase">Перейти в магазин</span>
							<span class="bottom-block text-uppercase">Для заказа и оплаты товаров</span>
						</a>
					</div><!-- /.head-cart -->
					<!--/noindex-->

				</div><!-- /.row -->
			</div><!-- /#masthead -->
		</header><!-- /.container -->

<?php get_template_part( 'view/navbar/_select_top_second' ); ?>
