<?php
/**
 * Шапка сайта с меню в виде кнопок.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

?>

		<header id="masthead-pills" class="container affix-add" itemscope itemtype="http://schema.org/WPHeader">
			<div class="masthead clearfix">
				<?php get_template_part( 'view/navbar/_meta_headline' ); ?>
				<div class="row">
					<div id="logo" class="col-md-4 col-sm-4">
						<a href="<?php echo home_url(); ?>" title="<?php bloginfo('name'); ?>"><img class="img-responsive" src="<?php bloginfo('template_url'); ?>/img/logo.png" alt="<?php bloginfo('name'); ?>" title="<?php bloginfo('name'); ?>" /></a>
					</div>

					<?php
					$veselka_phone = get_option('phone_number');
					if( $veselka_phone ) {
						$phone_sanitized = str_replace('+38', '', $veselka_phone);
						$phone_sanitized = str_replace(' ', '', $phone_sanitized);
						$phone_sanitized = '(' .
										substr($phone_sanitized, 0, 3) .
										') ' .
										substr($phone_sanitized, 3, 3) .
										'-' .
										substr($phone_sanitized, 6, 2) .
										'-' .
										substr($phone_sanitized, 8, 2);
					?>

					<div class="head-phone col-md-4 col-sm-4 col-xs-6">
						<a href="tel:<?php echo $veselka_phone; ?>" title="<?php bloginfo('name'); ?> - <?php echo __('Contact phone number', 'spiral' ); ?>">
							<span class="glyphicon glyphicon-phone-alt"></span>&nbsp;
							<?php echo $phone_sanitized; ?>
						</a>
					</div>
					<?php
					}
					
					$veselka_phone = get_option('phone_number2');
					if( $veselka_phone ) {
						$phone_sanitized = str_replace('+38', '', $veselka_phone);
						$phone_sanitized = str_replace(' ', '', $phone_sanitized);
						$phone_sanitized = '(' .
										substr($phone_sanitized, 0, 3) .
										') ' .
										substr($phone_sanitized, 3, 3) .
										'-' .
										substr($phone_sanitized, 6, 2) .
										'-' .
										substr($phone_sanitized, 8, 2);
					?>

					<div class="head-phone col-md-4 col-sm-4 col-xs-6">
						<a href="tel:<?php echo $veselka_phone; ?>" title="<?php bloginfo('name'); ?> - <?php echo __('Contact phone number', 'spiral' ); ?>">
							<span class="glyphicon glyphicon-phone-alt"></span>&nbsp;
							<?php echo $phone_sanitized; ?>
						</a>
					</div>
					<?php
					}

					$veselka_email = get_option('public_email');
					if( !$veselka_email ) {
						$veselka_email = get_option('admin_email');
					}
					if( $veselka_email ) {
					?>

					<div class="head-email col-md-4 col-sm-4 col-xs-6">
						<a href="mailto:<?php echo $veselka_email; ?>" title="<?php bloginfo('name'); ?> - <?php echo __('Write a letter', 'spiral' ); ?>">
							<span class="glyphicon glyphicon-envelope"></span>&nbsp;
							<?php echo $veselka_email; ?>
						</a>
					</div>
					<?php
					}
					?>

					<div id="menu" class="col-md-8 col-sm-12">

<?php get_template_part( 'view/navbar/menu-pills' ); ?>

					</div>

				</div><!-- /.row -->
			</div><!-- /#masthead -->
		</header><!-- /.container -->