<?php
/**
 * Шапка сайта с телефонами.
 *
 * @author veselka.ua
 * @version 0.3
 *
 * @package veselka_ua/themes
 */

?>
		<header id="masthead-shopping" class="container affix-add" itemscope itemtype="http://schema.org/WPHeader">
			<?php get_template_part( 'view/header/_meta_headline' ); ?>
			<div class="masthead clearfix">
				<div class="row">

					<div id="site-title" class="col-sm-2 col-md-2 col-lg-2">
						<?php
							if( !is_home() && !is_front_page() ) {
						?>
							<a id="logo" href="<?php echo get_home_url(); ?>" title="<?php bloginfo('name'); ?> - <?php bloginfo('description'); ?>">
								<img class="img-responsive" src="<?php echo TEMPLATE_URL; ?>/assets/img/logo.svg" alt="<?php bloginfo('name'); ?> - <?php bloginfo('description'); ?>">
							</a>
						<?php
							} else {
						?>
							<span id="logo">
								<img class="img-responsive" src="<?php echo TEMPLATE_URL; ?>/assets/img/logo.svg" alt="<?php bloginfo('name'); ?> - <?php bloginfo('description'); ?>">
							</span>
						<?php
							}
						?>
					</div><!-- /#site-title -->

					<div class="head-info head-phone col-sm-4 col-md-3 col-lg-3">
					<?php
						if( has_action( 'one_phone_head' ) ) {
							do_action( 'one_phone_head' );
						}
					?>
					</div><!-- /.head-phone -->

					<div class="head-info head-cart hidden-sm col-md-3 col-lg-3">
						<a class="modal-show" data-toggle="modal" data-target="#modal-measurement-form" title="Вызов замерщика">
							<span class="icon-block text-primary"><i class="fa fa-arrows fa-fw" aria-hidden="true"></i></span>
							<span class="top-block">Вызов замерщика</span>
							<span class="bottom-block">Выезд специалиста для замера</span>
						</a>
					</div><!-- /.modal -->

					<div class="head-info head-cart col-sm-3 col-md-2 col-lg-2">
						<a href="http://feran.events.od.ua/dostavka-dverei-po-ukraine.html" title="Способы доставки дверей Феран">
							<span class="icon-block text-primary"><i class="fa fa-truck fa-fw" aria-hidden="true"></i></span>
							<span class="top-block">Доставка</span>
							<span class="bottom-block">Оплата/Гарантия</span>
						</a>
					</div><!-- /.link -->

					<div class="head-info head-cart col-sm-3 col-md-2 col-lg-2">
						<a class="modal-show" data-toggle="modal" data-target="#modal-cart-form" title="Корзина">
							<span class="icon-block text-primary"><i class="fa fa-shopping-cart fa-fw" aria-hidden="true"></i></span>
							<span class="top-block">Корзина</span>
							<span id="cart-rem" class="bottom-block" data-empty="Нет заказов" data-full="Заказов ">Нет заказов</span>
						</a>
					</div><!-- /.head-cart -->

				</div><!-- /.row -->
			</div><!-- /#masthead -->
		</header><!-- /.container -->

<?php get_template_part( 'view/navbar/_select_top' ); ?>

