<?php
/**
 * Template Name: Home page
 * Template Post Type: page
 * 
 * Шаблон для отображения главной страницы без сайдбара.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

get_header();

// Слайдер на главной
get_template_part( 'view/homepage-slider' );
?>

				<section id="content" class="col-md-12">

				<header class="section-meta scroll-section clearfix">
					<h1 class="entry-title"><?php do_action('h1_title'); ?></h1>
				</header><!-- .entry-meta -->
				<?php
					if( have_posts() )
					{
						// Цикл Вордпресс
						while( have_posts() ) : the_post();
					?>

					<article  id="<?php echo $post->post_name ?>" <?php post_class("clearfix"); ?> itemscope itemtype="http://schema.org/Article">
						<meta itemprop="headline" content="<?php do_action('h1_title'); ?>">
						<?php
							// Плитка на главной
							get_template_part( 'view/homepage-menu-bar' );
						?>

						<div itemprop="articleBody" class="scroll-section entry-content">
							<?php the_content(); ?>

						</div><!-- .entry-content -->

					</article><!-- #page-<?php the_ID(); ?> -->

					<?php
						endwhile;
					}
				?>

				</section><!-- #content -->
<?php
	get_footer();
?>