<?php
/**
 * Получение параметров шаблона.
 * 
 * При создании данного метода, параметры из файла general.php записываются в соответствующие свойства объекта.
 * Дальнейшая работа с опциями шаблона осуществляется через свойства объекта. Например: $options->common['nav_menu']
 *
 * @author veselka.ua
 * @version 0.4
 *
 * @package veselka_ua/themes
 */

class WpThemeOptions {

	/**
	 * Объявление свойств объекта, имена свойств соответствуют именам массивов параметров.
	 * @type array
	 */
	protected $mode = [];


	public function __construct() {
		$this->load();
	}


	/**
	 * Получение параметров.
	 */
	public function __get($options) {
		return $this->$options;
	}


	/**
	 * Формирование параметров шаблона.
	 *
	 * @param void
	 * @return bool
	 */
	protected function load() {
		/**
		 * Стандартный путь к параметрам.
		 */
		require_once TEMPLATEPATH . '/conf/general.php';

		// Режим
		if( isset($mode) ) {
			$this->mode = $mode;
			if( !in_array( $mode, ['dev','prod','strict'] ) ) {
				$this->mode = 'strict';
			}
		} else {
			$this->mode = 'strict';
		}

		return true;

	}

	
	/**
	 * Проверка блока опций на наличие хотябы одной активированной опции.
	 *
	 * В случае успеха добавляет элемент массива с индексом 'on' равный 'true'.
	 * В случае провала условия массив заменяется единственным элементом с индексом 'on' равным 'false'.
	 *
	 * Принимает в качестве аргумента массив параметров.
	 * @param array $option
	 * @return array $option
	 */
	protected function at_least_one_enabled($option) {
		foreach( $option as $value ) {
			if( $value != false ) {
				$option['on'] = true;
				break;
			}
		}
		if( !$option['on'] ) {
			unset($option);
			$option['on'] = false;
		}
		return $option;
	}

} // end WpThemeOptions
?>