<?php
/**
 * Запись параметров шаблона.
 *
 * 
 * Установка нужных параметров водрпресс при установке шаблона.
 *
 *
 * @param string $theme_name
 *  
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class WpThemeInstall {


	public function __construct( $theme_name ) {

		// Имя шаблона
		if( $theme_name == NULL ) {
			return true;
		}

		// Настройки параметров единоразово, если тема еще не устанавливалась
		// В противном случае будет уничтожена персонализация
		if( get_option($theme_name) != 'installed' ) {
			add_action( 'init', [ $this, 'get_veselka_general_options' ], 10 );
			add_action( 'init', [ $this, 'get_veselka_theme_options' ], 20 );
			add_action( 'init', [ $this, 'get_veselka_theme_translates' ], 30 );
			add_action( 'init', [ $this, 'get_veselka_seo_options' ], 40 );
			add_action( 'init', [ $this, 'get_veselka_seo_translates' ], 50 );
			add_action( 'init', [ $this, 'get_veselka_gdrive_options' ], 60 );
			add_action( 'init', [ $this, 'get_veselka_img_sizes' ], 70 );
			// Запись флага предотвращающего повторную установку начальных параметров для всех шаблонов Veselka
			add_option( $theme_name, 'installed' );
		}

		// Если произошло переключение шаблонов Veselka или первоначальная установка, нужно перезаписать переводы SEO
		if( get_option('current_theme') != $theme_name ) {
			add_action( 'init', [ $this, 'get_veselka_theme_translates' ], 30 );
			add_action( 'init', [ $this, 'get_veselka_seo_translates' ], 50 );
			// Запись флага текущего шаблона
			// Предотвращающает повторную установку переводов
			add_option( 'current_theme', $theme_name );
		}
	}


	/**
	 * Параметры изображений.
	 *
	 * @param void
	 * @return void
	 */
	final public function get_veselka_img_sizes() {
		// Стандартные размеры
		if( get_option('thumbnail_size_w') != 370 ) { update_option('thumbnail_size_w',370); }
		if( get_option('thumbnail_size_h') != 370 ) { update_option('thumbnail_size_h',370); }
		if( get_option('thumbnail_crop') != 0 ) { update_option( 'thumbnail_crop', 0 ); }
		if( get_option('medium_size_w') != 770 ) { update_option('medium_size_w',770); }
		if( get_option('medium_size_h') != 770 ) { update_option('medium_size_h',770); }
		if( get_option('large_size_w') != 1170 ) { update_option('large_size_w',1170); }
		if( get_option('large_size_h') != 1170 ) { update_option('large_size_h',1170); }
	}


	/**
	 * Запись оптимальных параметров вордпресс единоразово.
	 *
	 * @param void
	 * @return void
	 */
	final public function get_veselka_general_options() {
		// Параметры вордпресс
		$home = str_replace( '/wp', '', get_option('home') );
		update_option( 'home', $home ); // Адрес главной страницы
		update_option( 'comment_moderation', 1 ); // Комментарий должен пройти проверку
		update_option( 'comments_notify', 0 ); // Оповестить когда кто-либо оставил комментарий
		update_option( 'default_comment_status', 'closed' ); // Статус комментариев по умолчанию
		update_option( 'default_ping_status', 'closed' ); // Статус пингбека по умолчанию
		update_option( 'default_pingback_flag', 0 ); // Пытаться оповестить блоги
		update_option( 'moderation_notify', 1 ); // Оповестить когда комментарий ожидает проверки
		update_option( 'avatar_default', 'gravatar_default' ); // Аватар
		update_option( 'gmt_offset', 2 ); // Временная зона
		update_option( 'permalink_structure', '/%category%/%postname%.html' ); // Постоянные ссылки
		update_option( 'template', 'veselka' ); // Шаблон
		update_option( 'public_year', '2005' ); // Год основания по умолчанию
		update_option( 'public_timezome', 'Europe/Kiev'); // Временна зона PHP
	}


	/**
	 * Параметры шаблона по умолчанию.
	 *
	 * @param void
	 * @return void
	 */
	final public function get_veselka_theme_options() {
		update_option( 'common_seo', 1 ); // Сео модуль
		update_option( 'common_gdrive', 0 ); // Импорт данных из Google Drive
		update_option( 'common_nav_menu', 1 ); // Навигационное меню
		update_option( 'common_nav_archives', 1 ); // Навигация в архиве
		update_option( 'common_advanced_search', 1 ); // Продвинутая форма поиска
		update_option( 'common_modal_forms', 1 ); // Модальные окна
		update_option( 'common_help_buttons', 1 ); // Вспомогательные кнопки
		update_option( 'btns_scrollup', 1 ); // Вспомогательные кнопки
		update_option( 'btns_scrolldown', 0 ); // Вспомогательные кнопки
		update_option( 'btns_search', 0 ); // Вспомогательные кнопки
		update_option( 'btns_social', 1 ); // Вспомогательные кнопки
		update_option( 'btns_binotel', 0 ); // Вспомогательные кнопки
		update_option( 'btns_phones', 0 ); // Вспомогательные кнопки
		update_option( 'btns_ask', 1 ); // Вспомогательные кнопки
		update_option( 'btns_bug', 0 ); // Вспомогательные кнопки
		update_option( 'btns_cart', 0 ); // Вспомогательные кнопки
		update_option( 'common_star_rating', 1 ); // Звездный рейтинг
		update_option( 'common_views_count', 1 ); // Количество просмотров статьи
		update_option( 'gallery_plain', 1 ); // Разметка bootstrap для галерей
		update_option( 'gallery_plain_highslide', 1 ); // Highslide библиотека
		update_option( 'gallery_plain_thumbnails', 1 ); // Размеры миниатюр
		update_option( 'gallery_type', 'owl' ); // Тип слайдера
		update_option( 'sidebar_enabled', 1 ); // Боковые панели
		update_option( 'sidebar_enabled_posts', 1 ); // Виджет постов
		update_option( 'sidebar_enabled_products', 0 ); // Виджет продуктов
		update_option( 'sidebar_enabled_menu', 1 ); // Виджет меню
		update_option( 'sidebar_enabled_tax', 1 ); // Виджет таксономий
		update_option( 'head_icons', 1 ); // Показывать иконки для мобильных устройств
		update_option( 'head_rss', 0 ); // Ссылка на rss
		update_option( 'head_cleanup', 1 ); // Очистка секции <head>
		update_option( 'head_cleanup_exerpts', 1 ); // Изменить: Читать далее
		update_option( 'head_cleanup_wp_version', 1 ); // Убрать версию WP
		update_option( 'head_cleanup_rsd_link', 1 ); // RSD ссылка
		update_option( 'head_cleanup_wlwmanifest_link', 1 ); // wlw ссылка
		update_option( 'head_cleanup_rel_canonical', 1 ); // Убрать каноническую ссылку по умолчанию
		update_option( 'head_cleanup_adjacent_posts_link', 1 ); // Убрать ссылки на следующую и предыдущую страницы
		update_option( 'head_cleanup_feed_links_extra', 1 ); // Убрать ссылки на фид
		update_option( 'head_cleanup_wp_shortlink_wp_head', 1 ); // Убрать короткую ссылку
		update_option( 'head_cleanup_wp_emojicons', 1 ); // Убрать скрипт иконок
		update_option( 'head_cleanup_rest_api', 1 ); // Отключить json для получения
		//update_option( 'var_header', '' ); // Заголовок
		//update_option( 'var_header_inner', '' ); // Внутренний заголовок
		//update_option( 'var_header_landing', '' ); // Заголовок лендинга
		//update_option( 'var_navbar', '' ); // Меню
		//update_option( 'var_navbar_fixed_top', 0 ); // Меню
		//update_option( 'var_navbar_inner', '' ); // Меню
		//update_option( 'var_navbar_inner_fixed_top', 0 ); // Меню
		//update_option( 'var_navbar_second', '' ); // Дополнительное меню
		//update_option( 'var_navbar_second_inner', '' ); // Дополнительное меню
		//update_option( 'var_navbar_footer', '' ); // Меню в футере
		//update_option( 'var_navbar_landing', 'top-nav-landing' ); // Меню в лендинге
		//update_option( 'var_footer', '' ); // Футер
		//update_option( 'var_footer_inner', '' ); // Внутренний футер
		//update_option( 'var_sidebar', '' ); // Сайдбар
	}


	/**
	 * Параметры шаблона по умолчанию (переводы).
	 *
	 * @param void
	 * @return void
	 */
	final public function get_veselka_theme_translates() {
		update_option( 'typ_title', __('Thank you for your message!', 'spiral' ) ); // Спасибо за Ваше обращение!
		update_option( 'typ_rem', __('Your interest to our site is important to us.', 'spiral' ) ); // Нам важен Ваш интерес к нашему сайту.
		update_option( 'typ_rem_ico', 'fa-bookmark-o' ); // Иконка.
		update_option( 'typ_primary', __('The message was successfully delivered.', 'spiral' ) ); // Сообщение успешно доставлено.
		update_option( 'typ_primary_ico', 'fa-paper-plane-o' ); // Иконка.
		update_option( 'typ_line1', __('Our manager will contact you as soon as possible.', 'spiral' ) ); // Наш менеджер свяжется с Вами ближайшее время.
		update_option( 'typ_line2', __('', 'spiral' ) ); // 
		update_option( 'typ_line3', __('', 'spiral' ) ); // 
	}


	/**
	 * Параметры SEO модуля.
	 *
	 * @param void
	 * @return void
	 */
	final public function get_veselka_seo_options() {

		//update_option( 'api_ga', '' ); // Universal Analitycs tracking ID 
		//update_option( 'api_gtag', '' ); // GTAG Analitycs tracking ID
		//update_option( 'api_gtm', '' ); // Google tag manager ID
		//update_option( 'api_metrika', '' ); // Yandex metrika ID
		//update_option( 'api_facebook', '' ); // Facebook application ID
		//update_option( 'api_facebook_pixel', '' ); // Facebook pixel
		update_option( 'metatitle', 1 ); // Заголовок
		update_option( 'metatitle_default_rule', '%blog_name%: %page_title% - %blog_description% - %url%' ); // Правила генерации заголовка по умолчанию
		//update_option( 'metatitle_page_rule', '' ); // Правила генерации заголовка на страницах
		//update_option( 'metatitle_post_rule', '' ); // Правила генерации заголовка в записях
		//update_option( 'metatitle_category_rule', '' ); // Правила генерации заголовка в рубриках
		//update_option( 'metatitle_products_rule', '' ); // Правила генерации заголовка в товарах
		//update_option( 'metatitle_catalog_rule', '' ); // Правила генерации заголовка в категориях товаров
		//update_option( 'metatitle_estate_rule', '' ); // Правила генерации заголовка в объектах недвижимости
		//update_option( 'metatitle_realty_rule', '' ); // Правила генерации заголовка в категориях объектов недвижимости
		update_option( 'metatags', 1 ); // Метатеги
		update_option( 'metatags_og', 1 ); // Open Graph
		update_option( 'metatags_description', 1 ); // Описание
		update_option( 'metatags_keywords', 1 ); // Ключевые слова
		update_option( 'metatags_robots', 1 ); //Robots
		update_option( 'metatags_canonical', 1 ); // Canonical
		update_option( 'metatags_default_rule', '%blog_name% - %page_title%. %ancestors%%blog_description% - %tel%' ); // Правила генерации описания по умолчанию
		//update_option( 'metatags_page_rule', '' ); // Правила генерации описания на страницах
		//update_option( 'metatags_post_rule', '' ); // Правила генерации описания в записях
		//update_option( 'metatags_category_rule', '' ); // Правила генерации описания в рубриках
		//update_option( 'metatags_products_rule', '' ); // Правила генерации описания в товарах
		//update_option( 'metatags_catalog_rule', '' ); // Правила генерации описания в категориях товаров
		//update_option( 'metatags_estate_rule', '' ); // Правила генерации описания в объектах недвижимости
		//update_option( 'metatags_realty_rule', '' ); // Правила генерации описания в категориях объектов недвижимости
		update_option( 'seotaxonomy', 1 ); // SEO в таксономиях, Показывать графический интерфейс
		update_option( 'seotaxonomy_identical_canonical', 1 ); // Одинаковая каноническая ссылка для всех страниц пагинации кроме главной.
		update_option( 'seotaxonomy_noindex_paged_tax', 1 ); // В таксономиях на страницы пагинации (кроме первой) добавляется meta robots = "noindex,follow"
		update_option( 'seotaxonomy_noindex_category', 0 ); // Не индексировать рубрики
		update_option( 'seotaxonomy_noindex_catalog', 0 ); // Не индексировать категории товаров
		update_option( 'seotaxonomy_noindex_realty', 0 ); // Не индексировать категории недвижимости
		update_option( 'seotaxonomy_noindex_tag', 1 ); // Не индексировать теги
		update_option( 'seotaxonomy_noindex_date', 1 ); // Не индексировать архивы дат
		update_option( 'seotaxonomy_noindex_author', 1 ); // Не индексировать архивы автора

		update_option( 'breadcrumbs', 1 ); // Хлебные крошки
		update_option( 'breadcrumbs_current', 1 ); // Показывать название текущей статьи/страницы/рубрики
		update_option( 'breadcrumbs_home_link', 1 ); // Показывать ссылку на главную страницу
		update_option( 'breadcrumbs_title', 1 ); // Показывать всплывающцю подсказку - (title) для ссылок
		update_option( 'xmlsitemap', 1 ); // Карта сайта xml
		update_option( 'xmlsitemap_debug', 1 ); // Режим отладки.
		update_option( 'xmlsitemap_se_ping', 1 ); // Оповещение поисковиков.
		update_option( 'xmlsitemap_stylesheet', 1 ); // Устанавливаем стили отображения XML карты.
	}


	/**
	 * Параметры SEO модуля (переводы).
	 *
	 * @param void
	 * @return void
	 */
	final public function get_veselka_seo_translates() {

		update_option( 'titleprefix_tag', __('Article archive tagged with', 'spiral' ) . ':' ); // Записи с меткой:
		update_option( 'titleprefix_author', __('Article archive of autor', 'spiral' ) . ':' ); // Архив Автора:
		update_option( 'titleprefix_day', __('Article archive for day', 'spiral' ) . ':' ); // Архив за день:
		update_option( 'titleprefix_month', __('Article archive for month', 'spiral' ) . ':' ); // Архив за месяц:
		update_option( 'titleprefix_year', __('Article archive for year', 'spiral' ) . ':' ); // Архив за год:
		update_option( 'titleprefix_search', __('Search results for', 'spiral' ) . ':' ); // Поиск по сайту:
		update_option( 'titleprefix_404', __('The requested page is not found - 404 error', 'spiral' ) ); // Ошибка 404
		update_option( 'titleprefix_paged', __('Page', 'spiral' ) ); // Страница

		update_option( 'breadcrumbs_home_anchor', '' ); // Текст ссылки главной страницы
		update_option( 'breadcrumbs_tag', __('Tag archive', 'spiral' ) . ':' ); // Записи с меткой:
		update_option( 'breadcrumbs_author', __('Autor archive', 'spiral' ) . ':' ); // Архив Автора:
		update_option( 'breadcrumbs_day', __('Day archive', 'spiral' ) . ':' ); // Архив за день:
		update_option( 'breadcrumbs_month', __('Month archive', 'spiral' ) . ':' ); // Архив за месяц:
		update_option( 'breadcrumbs_year', __('Year archive', 'spiral' ) . ':' ); // Архив за год:
		update_option( 'breadcrumbs_search', __('Search page', 'spiral' ) . ':' ); // Поиск по сайту:
		update_option( 'breadcrumbs_404', __('404 page', 'spiral' ) ); // Ошибка 404
		update_option( 'breadcrumbs_paged', __('Page', 'spiral' ) ); // Страница
	}



	/**
	 * Запись параметров импорта из Google Drive единоразово.
	 *
	 * @param void
	 * @return void
	 */
	final public function get_veselka_gdrive_options() {
		// Параметры вордпресс
/*		update_option( 'drive_credentials', '' ); // 
		update_option( 'wp_gdrive_page_id', '' ); // 
		update_option( 'wp_gdrive_page_title', '' ); // 
		update_option( 'category_gdrive_post_id', '' ); // 
		update_option( 'category_gdrive_post_title', '' ); // 
		update_option( 'category_gdrive_id', '' ); // 
		update_option( 'category_gdrive_title', '' ); // 
		update_option( 'catalog_gdrive_products_id', '' ); // 
		update_option( 'catalog_gdrive_products_title', '' ); // 
		update_option( 'catalog_gdrive_id', '' ); // 
		update_option( 'catalog_gdrive_title', '' ); // 
		update_option( 'realty_gdrive_estate_id', '' ); // 
		update_option( 'realty_gdrive_estate_title', '' ); // 
		update_option( 'realty_gdrive_id', '' ); // 
		update_option( 'realty_gdrive_title', '' ); // 
*/
	}


} // end WpThemeInit
?>