<?php
/**
 * Конструктор JS для загрузки приложений.
 *
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class WpApplications {

	use FileHandling, TemplatesLoad;

	/**
	 * Параметры.
	 * @type array
	 */
	private $options;
	/**
	 * Список приложений в виде массива опций.
	 * @type array
	 */
	private $app_list;


	public function __construct() {


		/**
		 * Хук для методов в шаблоне
		 * Передача текущего объекта в фильтр по ссылке для объктов использующих общие методы в шаблоне
		 */
		do_action_ref_array( 'wp_applications_exchange', [&$this] );

		// Аналитикс (GTAG) загружается автоматически при наличии идентификатора отслеживания
		$this->app_list[] = 'gtag';
		// Аналитикс (Universal) загружается автоматически при наличии идентификатора отслеживания
		$this->app_list[] = 'ga';
		// Тег менеджер загружается автоматически при наличии идентификатора отслеживания
		$this->app_list[] = 'gtm';
		// Яндекс метрика загружается автоматически при наличии идентификатора отслеживания
		$this->app_list[] = 'metrika';
		// Facebook Pixel загружается автоматически при наличии идентификатора
		$this->app_list[] = 'facebook_pixel';
		// Binotel загружается автоматически при активации опции в настройках
		$this->app_list[] = 'binotel';

		// В крючке вызывается метод определенный в родительском объекте
		add_action( 'head_applications', [$this, 'get_head_data'], 10, 0 );
		// В крючке вызывается метод определенный в родительском объекте
		add_action( 'body_applications', [$this, 'get_body_data'], 50, 0 );
		// В крючке вызывается метод определенный в родительском объекте
		add_action( 'footer_applications', [$this, 'get_footer_data'], 10, 0 );
	}


//////////////////// Публичные методы ////////////////////

	/**
	 * Скрипты вызываемые в заголовке.
	 * 
	 * Обращение происходит в крючке ворпресс.
	 *
	 * @param void
	 * @return string
	 */
	final public function get_head_data() {
		echo $this->construct_data('head');
	}


	/**
	 * Скрипты вызываемые в теле сайта.
	 * 
	 * Обращение происходит в крючке ворпресс.
	 *
	 * @param void
	 * @return string
	 */
	final public function get_body_data() {
		echo $this->construct_data();
	}


	/**
	 * Скрипты вызываемые в подвале.
	 * 
	 * Обращение происходит в крючке ворпресс.
	 *
	 * @param void
	 * @return string
	 */
	final public function get_footer_data() {
		echo $this->construct_data('footer');
	}


	/**
	 * Обертка для записи новых элементов в массив приложений.
	 *
	 * @param string $app_name
	 * @return void
	 */
	public function set_new_app( $app_name = false ) {
		if( !$app_name ) {
			return false;
		}
		$this->app_list[] = $app_name;
	}


//////////////////// Приватные и защищенные методы ////////////////////

	/**
	 * Код загрузки приложений.
	 *
	 * @param string $placement
	 * @return string
	 */
	private function construct_data( $placement = '' ) {

		// Текущий суффикс
		if( $placement != '' ) {
			$placement = '_' . $placement;
		}
		//var_dump($this->app_list);
		$result_set = '';
		foreach( $this->app_list as $app_name ) {
			// Поиск опции
			if( !(bool)get_option('api_' . $app_name) ) {
				continue;
			}
			// Проверка существования файла
			$file_name = $app_name . $placement;
			$this->options['files'][$file_name] = $file_name . '.php';
			if( !$this->check_template( $file_name, 'body_applications' ) ) {
				continue;
			}
			// Формирование результата
			$result_set .= $this->template_replacement( ['APP_KEY'=>get_option('api_' . $app_name)], $file_name, 'body_applications' );
		}
		return $result_set;
	}



} //end WpApplications
?>