<?php
/**
 * Пути к плагинам.
 *
 * Проверяет наличие плагина.
 * Генерирует массив путей на сервере.
 * Генерирует массив путей ссылок.
 *
 * Дополнения для плагинов (сделано так, чтобы избежать ебли с передачей путей из плагинов).
 * Перечислен список путей -> проверен список путей -> неактивыней пошли лесом.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

trait PluginsPath {

	/**
	 * Список реципиентов (плагинов).
	 * Совпадает с именами плагинов без префикса "Veselka_".
	 * @type array
	 */
	protected $plugins = [];

	/**
	 * Список плагинов (имен).
	 * Ключ массива cовпадает с зарегистрированным типом файлов в плагине.
	 * Значение массива - имя плагина без префикса.
	 *
	 * ...
	 * <имя плагина> => <имя типа записей>
	 * ...
	 *
	 * @type array
	 */
	protected $plugins_posts = false;

	/**
	 * Список реципиентов (плагинов).
	 * Ключ массива совпадает с зарегистрированными таксономиями в плагинах.
	 * Значение массива - имя плагина без префикса.
	 *
	 * ...
	 * <имя плагина> => <имя таксономии>
	 * ...
	 *
	 * @type array
	 */
	protected $plugins_tax = false;

	/**
	 * Пути на сервере к каталогу с плагином.
	 * @type array
	 */
	protected $plugins_path = [];

	/**
	 * Ссылки до каталога плагина.
	 * @type array
	 */
	protected $plugins_url = [];


//////////////////// Приватные и защищенные методы ////////////////////


	// Проверка наличия плагина
	// Плагины могут быть дочерними (частными случаями)
	// Имена констрант с путями могут совпадать для разных имен плагинов
	//$this->check_plugins();


	/**
	 * Списки плагинов.
	 *
	 * @param void
	 * @return void
	 */
	private function set_lists() {

		// Список плагинов
		// Значения cовпадают с зарегистрированными типоми файлов в плагине.
		// Значения cовпадают с зарегистрированными таксономиями в плагинах.
		$this->plugins_posts = [
			'landing-elements'	=>	'landing',// Лендинг
			'rooms'		=>	'hotels',		// Дополение к отелям
			'products'	=>	'shop',			// Магазин
			'products'	=>	'shop_feran',	// Калькулятор Феран (Временное решение, надобы автоматизировать)
			'estate'	=>	'realty',		// Недвижимость
			'works'		=>	'portfolio',	// Портфолио
			'employees'	=>	'team',			// Команда
			'attendance'=>	'services',		// Услуги
			'shares'	=>	'actions',		// Акции
			'hash'		=>	'hash',			// Генератор случайных чисел
		];

		$this->plugins_tax = [
			'landing'	=>	'landing',		// Лендинг
			'hotels'	=>	'hotels',		// Дополение к отелям
			'catalog'	=>	'shop',			// Магазин
			'catalog'	=>	'shop_feran',	// Калькулятор Феран (Временное решение, надобы автоматизировать)
			'realty'	=>	'realty',		// Недвижимость
			'portfolio'	=>	'portfolio',	// Портфолио
			'team'		=>	'team',			// Команда
			'services'	=>	'services',		// Услуги
			'actions'	=>	'actions',		// Акции
			'hash'		=>	'hash',			// Генератор случайных чисел
		];

	}


	/**
	 * Проверка наличия плагина.
	 * Плагины могут быть дочерними (частными случаями)
	 * Имена констрант с путями могут совпадать для разных имен плагинов
	 *
	 * @param void
	 * @return void
	 */
	protected function check_plugins() {

		// Уже запускалось?
		if( $this->plugins_posts !== false && $this->plugins_tax !== false ) {
			return true;
		}

		// Списки плагинов.
		$this->set_lists();

		// Активыне плагины WP
		$plugins_array = get_option( 'active_plugins' );

		// Фильтрация списка в соответствии с установленными плагинами
		if( NULL != $plugins_array ) {
			// Перебор установленных плагинов
			foreach( $plugins_array as $plugin_path ) {
				// Выделение каталога из пути
				$plugin_path = explode('/',$plugin_path);
				$plugin_path = $plugin_path[0];
				// Проверяем наличия пути (URL адрес до каталога с плагином)
				$plugin = str_replace('veselka_','',$plugin_path);
				$prefix = explode('_',$plugin);
				$prefix = strtoupper($prefix[0]);
				$const_dir = $prefix . '_PATH';
				$const_url = $prefix . '_DIR_URL';
				// Проверка наличия константы с путем
				if( defined($const_url) && defined($const_dir) ) {
					$this->plugins[] = $plugin;
					$this->plugins_path[$plugin] = constant($const_dir);
					$this->plugins_url[$plugin] = constant($const_url);
				}
			}
		}

		// Фильтрация предоставленного списка плагинов AC VESELKA
		foreach( $this->plugins_posts as $post => $plugin ) {
			if( !in_array( $plugin, $this->plugins ) ) {
				// Удаляем плагин
				unset( $this->plugins_posts[$post] ); // Типы постов
			}
		}
		foreach( $this->plugins_tax as $tax => $plugin ) {
			if( !in_array( $plugin, $this->plugins ) ) {
				// Удаляем плагин
				unset( $this->plugins_tax[$tax] ); // Таксономии
			}
		}
	}


} //end PluginsPath