<?php
/**
 * Одиночка
 *
 * При создании веб приложения, часто требуется концептуально и архитектурно предоставить доступ только к одному экземпляру определённого класса.
 * Шаблон Одиночка позволяет это сделать.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class Singleton
{

	/**
	 * Сущность.
	 * @type obj
	 */
    protected static $instance;
    

	/**
	 * Получение единственной сущности объекта.
	 *
	 * @param void
	 * @return string|bool
	 */
    public static function get_instance()
    {
        if (null === static::$instance) {
            static::$instance = new static();
        }

        return static::$instance;
    }

	/**
	 * Защита объекта от получение новой версии через конструктор.
	 *
	 * @param void
	 * @return void
	 */
    protected function __construct()
    {
    }

	/**
	 * Защита объекта от получение новой версии через клонирование.
	 *
	 * @param void
	 * @return void
	 */
    private function __clone()
    {
    }

	/**
	 * Защита объекта от получение новой версии через восстановление.
	 *
	 * @param void
	 * @return void
	 */
    private function __wakeup()
    {
    }

} // end Singleton