<?php
/**
 * Формирует боковое навигационное меню.
 * 
 * @param object $lib_construct
 *
 * @author veselka.ua
 * @version 0.2
 *
 * @package veselka_ua/themes
 */

class Sidebar {

	/**
	 * Объект обработки библиотек.
	 * @type object
	 */
	private $lib_kit;
	/**
	 * Массив параметров.
	 * @type array
	 */
	private $options;
	/**
	 * Параметры виджетов
	 * @type array
	 */
	private $widgets = [];
	/**
	 * Аргументы динамических сайдбаров
	 * @type array
	 */
	private $sidebar_args = [];

	public function __construct() {

		/**
		 * Хук для получение объекта с общими методами.
		 */
		add_action( 'wp_lib_construct_exchange', [$this, 'get_wp_lib_construct'], 30, 1 );

		// Параметры по умолчанию
		$this->options['lib'] = false;

		// Инициализация сайдбаров
		$this->load_sidebar_args();
		$this->load_sidebars();
		// Инициализаци виджетов
		$this->widgets = [ 'posts', 'products', 'menu', 'tax' ];
		$this->load_widgets();

		add_action( 'print_sidebar', [$this, 'get_sidebar'], 10, 1 );
	}


//////////////////// Публичные методы ////////////////////


	/**
	 * функция хука для получения общего объекта по ссылке.
	 *
	 * Сортировка.
	 *
	 * @param object $lib_construct
	 * @return void
	 */
	final public function get_wp_lib_construct( $lib_construct ){
		// Объект с общими методами в локальное свойство
		$this->lib_kit = $lib_construct;
	}


	/**
	 * Оберткка для получения заданного сайдбара.
	 *
	 * @param string $sidebar_name
	 * @return void
	 */
	public function get_sidebar( $sidebar_name ) {

		// Загрузка библиотек
		if( !$this->options['lib'] ) {
			$this->lib_kit->set_new_lib('sidebars');
			$this->options['lib'] = true;
		}

		dynamic_sidebar( $sidebar_name );
	}


//////////////////// Приватные методы ////////////////////

	/**
	 * Аргументы динамических сайдбаров.
	 *
	 * @param void
	 * @return void
	 */
	private function load_sidebar_args() {
		// Аргументы для сайдбара
		$this->sidebar_args['primary']['name'] = 'Боковое меню';
		$this->sidebar_args['primary']['id'] = 'sidebar-primary';
		$this->sidebar_args['primary']['description'] = 'Для статической части сайта';
		$this->sidebar_args['primary']['class'] = 'nav nav-list';
		$this->sidebar_args['primary']['before_widget'] = '<div id="%1$s" class="widget %2$s">';
		$this->sidebar_args['primary']['after_widget'] = '</div>';
		$this->sidebar_args['primary']['before_title'] = '<h3 class="widget-title">';
		$this->sidebar_args['primary']['after_title'] = '</h3>';
		// Аргументы для сайдбара на страницах
		$this->sidebar_args['navigation']['name'] = 'Навигация на страницах';
		$this->sidebar_args['navigation']['id'] = 'sidebar-navigation';
		$this->sidebar_args['navigation']['description'] = 'Для страниц';
		$this->sidebar_args['navigation']['class'] = 'nav nav-list';
		$this->sidebar_args['navigation']['before_widget'] = '<div id="%1$s" class="widget %2$s">';
		$this->sidebar_args['navigation']['after_widget'] = '</div>';
		$this->sidebar_args['navigation']['before_title'] = '<h3 class="widget-title">';
		$this->sidebar_args['navigation']['after_title'] = '</h3>';
		// Аргументы для сайдбара на страницах
		$this->sidebar_args['scrollspy']['name'] = 'Навигация в ленте страниц';
		$this->sidebar_args['scrollspy']['id'] = 'sidebar-scrollspy';
		$this->sidebar_args['scrollspy']['description'] = 'Для ленты страниц';
		$this->sidebar_args['scrollspy']['class'] = 'nav nav-list';
		$this->sidebar_args['scrollspy']['before_widget'] = '<div id="%1$s" class="widget %2$s">';
		$this->sidebar_args['scrollspy']['after_widget'] = '</div>';
		$this->sidebar_args['scrollspy']['before_title'] = '<h3 class="widget-title">';
		$this->sidebar_args['scrollspy']['after_title'] = '</h3>';
		// Аргументы для сайдбара в продуктах
		$this->sidebar_args['product']['name'] = 'Боковое меню в товарах';
		$this->sidebar_args['product']['id'] = 'sidebar-products';
		$this->sidebar_args['product']['description'] = 'Для товаров';
		$this->sidebar_args['product']['class'] = 'nav nav-list';
		$this->sidebar_args['product']['before_widget'] = '<div id="%1$s" class="widget %2$s">';
		$this->sidebar_args['product']['after_widget'] = '</div>';
		$this->sidebar_args['product']['before_title'] = '<h3 class="widget-title">';
		$this->sidebar_args['product']['after_title'] = '</h3>';
	}


	/**
	 * Регистрация динамических сайдбаров.
	 *
	 * @param void
	 * @return void
	 */
	private function load_sidebars() {
		foreach( $this->sidebar_args as $options ) {
			register_sidebar( $options );
		}
	}


	/**
	 * Регистрация виджетов.
	 *
	 * TODO: Переместить файлы классов виджетов в каталог lib/widget
	 *
	 * @param void
	 * @return void
	 */
	private function load_widgets() {
		//require_once TEMPLATEPATH . '/lib/widgets/kernel.class.php';
        foreach( $this->widgets as $widget ) {
			$file_path = TEMPLATEPATH . '/view/widgets/' . $widget . '.class.php';
			if( (bool)get_option('sidebar_enabled_'.$widget) && file_exists($file_path) ) {
				$widget_name = 'Veselka' . ucfirst($widget);
				include( $file_path );
				add_action('widgets_init', create_function('', 'return register_widget("' . $widget_name . '");'));
			}
        }
    }

} //end Sidebar
?>