<?php
/**
 *  .
 *
 * 1.    .
 *
 *
 *
 * @author veselka.ua
 * @version 2.0
 *
 * @package veselka_ua/themes
 */

class SeoCleaner {

	/**
	 *     .
	 * @type string
	 */
	private $regexp = '<a\s[^>]*href=(\"??)([^\" >]*?)\\1[^>]*>';


	public function __construct() {
		//    
		add_filter( 'the_content', [$this, 'link_noindex'] );
	}


	/**
	 *    .
	 *
	 * @param string $content
	 * @return string
	 */
	public function link_noindex( $content ) {

		if( !preg_match_all("/$this->regexp/siU", $content, $matches, PREG_SET_ORDER) ) {
			return $content;
		}
		if( empty($matches) ) {
			return $content;
		}

		//$ownDomain = get_option('home');
		$ownDomain = $_SERVER['HTTP_HOST'];

		foreach( $matches as $match ) {
			$tag = $tag2 = $url = $match[0];

			// bypass #more type internal link
			$res = preg_match('/href(\s)*=(\s)*"[#|\/]*[a-zA-Z0-9-_\/]+"/',$url);
			if( $res ) {
				continue;
			}

			$pos = strpos($url,$ownDomain);
			if( $pos !== false ) {
				continue;
			}

			// 
			$tel = explode(':', $url);
			if( $tel[0] == 'tel' ) {
				continue;
			}

			$noFollow = '';

			// add target=_blank to url
			$pattern = '/target\s*=\s*"\s*_blank\s*"/';
			preg_match($pattern, $tag2, $match, PREG_OFFSET_CAPTURE);
			if( count($match) < 1 ) {
				$noFollow .= ' target="_blank"';
			}

			//add nofollow
			$pattern = '/rel\s*=\s*"\s*[n|d]ofollow\s*"/';
			preg_match($pattern, $tag2, $match, PREG_OFFSET_CAPTURE);
			if( count($match) < 1 ) {
				$noFollow .= ' rel="nofollow"';
			}

			// add nofollow/target attr to url
			$tag = rtrim ($tag,'>');
			$tag .= $noFollow.'>';
			$content = str_replace($tag2,$tag,$content);
		}

		$content = str_replace(']]>', ']]&gt;', $content);
		return $content;
	}


} //end SeoCleaner
?>