<?php
/**
 * Построение Хлебных крошек.
 *
 * Формирует навигационную цепочку от корня (главной страницы) до текущей страницы.
 *
 *
 *
 * @param object $semantic_kernel
 * @param object $lib_construct
 * @param array $options
 *
 * @author veselka.ua
 * @version 2.0
 *
 * @package veselka_ua/themes
 */

class SeoBreadcrumbs {

	/**
	 * Объект семантического ядра.
	 * @type object
	 */
	private $semantic_kernel;
	/**
	 * Параметры SEO модуля.
	 * @type array
	 */
	private $options = [];
	/**
	 * Массив необходимых для работы HTML оберток.
	 * @type array
	 */
	private $html_elements = [];
	/**
	 * Свойство для обработки данных в дочернем объекте.
	 * @type array
	 */
	private $seo_data = [];


	public function __construct( &$semantic_kernel = false ) {

		/**
		 * Объект семантического ядра.
		 */
		if( $semantic_kernel && is_object($semantic_kernel) ) {
			$this->semantic_kernel = $semantic_kernel;
		}

		// В крючке вызывается метод определенный в родительском объекте
		add_action( 'bread_crumbs', [$this, 'get_data'], 10, 0 );
	}


	/**
	 * Обертка для получения результата работы объекта.
	 * 
	 * Обращение происходит в крючке ворпресс.
	 * Крючек вордпресс должен находится в конструкторе объекта.
	 *
	 * @param void
	 * @return string
	 */
	final public function get_data() {
		echo $this->construct_seo_data();
	}


	/**
	 * Получение результата.
	 *
	 * @param void
	 * @return string
	 */
	private function construct_seo_data() {
		// Текущее состояние семантического ядра и сбор данных
		$this->semantic_kernel->load();
		// Подготовка объекта к работе
		$this->load();
		// Сбор прописанных данных
		$this->seo_collect();
		// Генерация недостающих данных
		$this->seo_generate();
		// HTML оформление SEO данных
		return $this->seo_formalization();
	}


	/**
	 * Подготовка объекта к работе.
	 *
	 * @param void
	 * @return void
	 */
	private function load() {
		// Обявление результарующей переменной
		$this->seo_data['bread_сrumbs'] = false;
		// Анкор главной
		$home_anchor = get_option('breadcrumbs_home_anchor');
		if( !is_string( $home_anchor ) || $home_anchor == '' ) {
			$this->options['home_anchor'] = get_option('blogname');
		} else {
			$this->options['home_anchor'] = $home_anchor;
		}
		// Загрузка библиотек
		/*if( !$this->options['lib'] ) {
			$this->lib_kit->set_new_lib('breadcrumbs');
			$this->options['lib'] = true;
		}*/
		/**
		 * Формирование необходимых для работы HTML оберток
		 */
		// Пеерход на новую строку
		$this->html_elements['new_line'] = PHP_EOL . "\t\t\t";
		// Ссылка домашней страницы
		$this->html_elements['home_link'] = home_url('/');
		// Обертка для ссылки (до)
		$this->html_elements['link_before'] = $this->html_elements['new_line'] . '<div itemscope itemtype="http://data-vocabulary.org/Breadcrumb">';
		// Обертка для ссылки (после)
		$this->html_elements['link_after'] = '</div>';
		// Тег перед текущим элементом навигации
		$this->html_elements['active_link_before'] = $this->html_elements['new_line'] . '<span class="active">';
		// Тег после текущего элемента навигации
		$this->html_elements['active_link_after'] = '</span>';
		// Атрибут ссылки
		$this->html_elements['link_atr'] = ' itemprop="url"';
		// Обертка для анкора (до)
		$this->html_elements['anchor_before'] = $this->html_elements['new_line'] . '<span itemprop="title">';
		// Обертка для анкора (после)
		$this->html_elements['anchor_after'] = '</span>';
		// Обертка для анкора (до)
		$this->html_elements['active_anchor_before'] = $this->html_elements['new_line'] . '';
		// Обертка для анкора (после)
		$this->html_elements['active_anchor_after'] = '';
		// Разделитель между элементами навигации
		$this->html_elements['delimiter'] = $this->html_elements['new_line'] . '<span class="divider">/</span>';
		// Контейнер для хлебных кошек (до)
		$this->html_elements['bread_сrumbs_before'] = $this->html_elements['new_line'];
		$this->html_elements['bread_сrumbs_before'] .= '<div class="breadcrumb primary-font affix-add">';
		// Контейнер для хлебных кошек (после)
		$this->html_elements['bread_сrumbs_after'] = $this->html_elements['new_line'] . '</div><!-- .breadcrumb -->';
	}


	/**
	 * -- Метод объявлен в родительском объекте --
	 * @depricated since v.2.01b
	 *
	 * @param void
	 * @return bool
	 */
	private function seo_collect() {
		return false;
	}


	/**
	 * Сборка ссылки (элемента навигации) в зависимости от параметров
	 *
	 * @param string $title
	 * @param string $anchor
	 * @param string $url
	 * @param bool $active
	 * @return void
	 */
	private function crumb_construct($title, $anchor, $url='', $active = true) {
		// Временная переменная
		$result_set = '';
		// Переключатель переменных
		if( $active ) {
			$active = 'active_';
		} else {
			$active = '';
		}
		// Обертка анкора ссылки
		$anchor = $this->html_elements[$active . 'anchor_before'] . $anchor . $this->html_elements[$active . 'anchor_after'];
		// Тег перед элементом навигации
		$result_set .= $this->html_elements[$active . 'link_before'];
		// Проверка пренадлежности элемента к навигации
		if( $active == '' ) {
			$result_set .= '<a href="' . $url . '"';
			$result_set .= $this->html_elements['link_atr'];
			// Если тайтл включен в опциях
			if( (bool)get_option('breadcrumbs_title') ) {
				$result_set .= ' title="' . $title . '"';
			}			
			$result_set .= '>' . $anchor . '</a>';
			$result_set .= $this->html_elements['delimiter'];
		} else {
			$result_set .= $anchor;
		}
		// Тег после элемента навигации
		$result_set .= $this->html_elements[$active . 'link_after'];
		// Результирующая переменная
		$this->seo_data['bread_сrumbs'] .= $result_set;
	}


	/**
	 * Генерация хлебных крошек
	 *
	 * @param void
	 * @return void
	 */
	private function seo_generate() {
		//var_dump($this->semantic_kernel->registry);
		if( !$this->semantic_kernel->registry['front_page'] ) {

			// Корень цепочки
			if( (bool)get_option('breadcrumbs_home_link') ) {
				$this->crumb_construct( get_option('desctiption'), $this->options['home_anchor'], $this->html_elements['home_link'], $active = false);
			}

			// Предки
			if( isset($this->semantic_kernel->registry['ancestors']) ) {
				foreach( $this->semantic_kernel->registry['ancestors'] as $key => $ancestor ) {
					$this->crumb_construct( $ancestor['title'], $ancestor['title'], $ancestor['link'], $active = false);					
				}
			}

			// Текущая страница
			if( (bool)get_option('breadcrumbs_current') ) {
				// Если есть спец переменная
				if( isset($this->semantic_kernel->registry['crumb']) ) {
					$anchor = $this->semantic_kernel->registry['crumb'];
				} else {
					$anchor = $this->semantic_kernel->registry['title'];
				}
				// Префикс хлебных крошек
				$anchor_prefix = get_option('breadcrumbs_'.$this->semantic_kernel->registry['current_mode']);
				if( (bool)$anchor_prefix && $anchor_prefix != '' ) {
					$anchor = $anchor_prefix . ' ' . $anchor;
				}

				// Добавление заголовока
				$title = '';
				if( isset($this->semantic_kernel->registry['title']) && $this->semantic_kernel->registry['title'] !== '' ) {
					$title .= $this->semantic_kernel->registry['title'];
				}
				// Добавление элемента заголовка (префикс архива)
				$title_prefix = get_option('titleprefix_'.$this->semantic_kernel->registry['current_mode']);
				if( (bool)$title_prefix && $title_prefix != '' ) {
					if( $title != '' ) {
						$title = ' ' . $title;
					}
					$title = $title_prefix . $title;
				}

				$this->crumb_construct($title, $anchor);
			}
		}
	}


	/**
	 * Формирование HTML кода хлебных крошек.
	 *
	 * @param void
	 * @return string
	 */
	private function seo_formalization() {
		if( $this->seo_data['bread_сrumbs'] ) {
			$this->seo_data['bread_сrumbs'] = $this->html_elements['bread_сrumbs_before'] . $this->seo_data['bread_сrumbs'];
			$this->seo_data['bread_сrumbs'] .= $this->html_elements['bread_сrumbs_after'];
		}
		return $this->seo_data['bread_сrumbs'];
	}


} //end SeoBreadcrumbs
?>