<?php
/**
 * Дополнительнае поля на странице категории.
 *
 * SEO данные.
 *
 *
 * @author veselka.ua
 * @version 0.2
 *
 * @package veselka_ua/themes
 */

class SeoAdmin {

	/**
	 * Первичный объект модификации интерфейса категорий.
	 * @type object
	 */
	private $gui_taxonomy_kernel;


	public function __construct() {
		/**
		 * Добавляет произвольные SEO поля в таксономиях.
		 * Вызов функции при инициализации административного раздела.
		 */
		add_action( 'admin_init', [ $this, 'seo_taxonomy_custom_fields'], 100 );
		/**
		 * Хук для получение объекта с общими методами.
		 */
		add_action( 'seo_gui_taxonomy', [$this, 'get_taxonomy_kernel'], 10, 1 );
	}


	/**
	 * функция хука для получения общего объекта по ссылке.
	 *
	 * SEO.
	 *
	 * @param object $gui_taxonomy_kernel
	 * @return void
	 */
	final public function get_taxonomy_kernel( $gui_taxonomy_kernel ){
		// Объект с общими методами в локальное свойство
		$this->gui_taxonomy_kernel = $gui_taxonomy_kernel;
	}


	/**
	 * функция расширения функционала административного раздела.
	 *
	 * SEO функции во всех зарегистрированных таксономиях.
	 *
	 * @param void
	 * @return void
	 */
	final public function seo_taxonomy_custom_fields() {
		// Нет параметров
		if( !isset($this->gui_taxonomy_kernel->tax) || empty($this->gui_taxonomy_kernel->tax) ) {
			return NULL;
		}
		$priority = 100;
		foreach($this->gui_taxonomy_kernel->tax as $tax => $flag ) {
			if(!$flag) {
				continue;
			}
			// Добавления SEO поля в рубрики и во все дополнительные таксономии переданные в родительский объект
			add_action( $tax . '_edit_form_fields', [ $this, 'seo_custom_fields_form'], $priority );
			//$priority += 10;
		}
	}


	/**
	 * Вывод HTML разметки в таксономиях.
	 *
	 * @param object $tag
	 * @return string
	 */
	final public function seo_custom_fields_form($tag) {

		// Наименования параметров
		$filepath = TEMPLATEPATH . '/conf/tax_meta_seo.php';
		if( !$this->gui_taxonomy_kernel->check_file($filepath) ) {
			return false;
		}
		require_once $filepath;

		// Никаких полей если масивы пусты
		if( empty($cat_fields) || empty($general) ) {
			return true;
		}

		// Вывод заголовка
		$this->gui_taxonomy_kernel->options_header($general);

		// Получение параметров
		$term_id = $tag->term_id;
		$cat_meta = get_term_meta( $term_id );

		/*$t_id = $tag->term_id;
		if( is_category() ) {
			$cat_meta = get_option("category_$t_id");
		} else {
			$cat_meta = get_option("taxonomy_$t_id");
		}*/

		// Исключения (с датой индивидуальный подход)
		$cat_modify = $cat_fields['cat_modify'];
		unset($cat_fields['cat_modify']);

		// Вывод полей
		$this->gui_taxonomy_kernel->options_print( $cat_meta, $cat_fields, $cat_remarka, $restrict_write );

		?>

		<tr class="form-field">
			<th scope="row" valign="top">
				<label for="cat_meta[cat_modify]"><?php echo $cat_modify; ?></label>
			</th>
			<td>
				<input type="hidden" name="cat_meta[cat_modify]" id="cat_meta[cat_modify]" value="<?php $date = date_create(); echo date_format($date, 'Y-m-d H:i:s'); ?>">
				<p><?php echo $cat_meta['cat_modify'][0] ? date_format(date_create($cat_meta['cat_modify'][0]), 'Y-m-d H:i:s') : 'none'; ?></p>
				<span class="description"><?php echo $cat_remarka['cat_modify'] ?></span>
			</td>
		</tr>

	<?php
	}


} //end SeoAdmin