<?php
/**
 * Поиск.
 * 
 * Расширенные инструменты поиска.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class Search {


	public function __construct() {
		// Добавление пользвоательских типов записей в запрос wp_query
		//add_filter( 'pre_get_posts', [ $this, 'set_post_types_search' ] );
		// Поиск по тааксономиям
		add_filter( 'posts_join', [ $this, 'adv_search_join' ], 10, 2 );
		add_filter( 'posts_where', [ $this, 'adv_search_where' ], 10 ,2 );
		add_filter( 'posts_groupby', [ $this, 'adv_search_groupby' ], 10, 2 );

	}


//////////////////// Публичные методы ////////////////////


	/**
	 * Модифицирует основной запрос wp_query для замены типов записи 'post' по умолчанию
	 * на пользовательские типы записей.
	 *
	 * @param object $query - Оригинальный запрос.
	 * @return object $query - Измененный запрос.
	 */
	final function set_post_types_search( $query ) {
		if ( $query->is_search ) {
			$query->set( 'post_type', [ 'post', 'page', 'products', 'estate', 'rooms', 'service' ] );
		}
		return $query;
	}


	/**
	 * Объединение результирущего поиска потаксоноимям.
	 *
	 * @param string $join
	 * @return string
	 */
	final public function adv_search_join( $join, $query ){

        global $wpdb;

        if ( is_main_query() && is_search() ) {

            $join .= "
                LEFT JOIN
                (
                    {$wpdb->term_relationships}
                    INNER JOIN
                        {$wpdb->term_taxonomy} ON {$wpdb->term_taxonomy}.term_taxonomy_id = {$wpdb->term_relationships}.term_taxonomy_id
                    INNER JOIN
                        {$wpdb->terms} ON {$wpdb->terms}.term_id = {$wpdb->term_taxonomy}.term_id
                )
                ON {$wpdb->posts}.ID = {$wpdb->term_relationships}.object_id ";

        }

        return $join;

	}


	/**
	 * Поиск пользовательской таксономии.
	 *
	 * @param string $where
	 * @return string
	 */
	final public function adv_search_where( $where, $query ){

        global $wpdb;

        if ( is_main_query() && is_search() ) {

            $taxonomies = $this->posts_where_taxonomies();
            $taxonomies = implode( ', ', $taxonomies );

            $where .= " OR (
                            {$wpdb->term_taxonomy}.taxonomy IN( {$taxonomies} )
                            AND
                            {$wpdb->terms}.name LIKE '%" . esc_sql( get_query_var( 's' ) ) . "%'
                        )";

        }

        return $where;

	}


	/**
	 * Групповой поиск по таксономиям.
	 *
	 * @param void
	 * @return string
	 */
	final public function adv_search_groupby( $groupby, $query ){

        global $wpdb;

        if ( is_main_query() && is_search() ) {
            $groupby = "{$wpdb->posts}.ID";
        }

        return $groupby;

	}


    /**
     * Get an array of taxonomy names used within the posts_where clause.
     *
     * All taxonomies will be escaped with esc_sql().
     *
     * @uses esc_sql()
     * @see https://codex.wordpress.org/Function_Reference/esc_sql
     *
     * @since 1.0.0
     *
     * @return array An array of taxonomy names.
     */
    public function posts_where_taxonomies() {

        $taxonomies = [
            'category',
            'post_tag',
			'hotels',
			'catalog',
			'realty',
			'services'
        ];

        /**
         * Filter 'sts_posts_where_taxonomies'.
         *
         * Alter the taxonomies for the post where clause before they are
         * formatted and escaped.
         *
         * @since 1.0.0
         *
         * @param array $taxonomies An array of taxonomy names.
         */
        $taxonomies = apply_filters( 'sts_posts_where_taxonomies', $taxonomies );

        foreach( $taxonomies as $index => $taxonomy ) {
            $taxonomies[ $index ] = sprintf( "'%s'", esc_sql( $taxonomy ) );
        }

        return $taxonomies;

    }



} // end Search
?>