<?php
/**
 * Построение Контаактной формы
 * 
 * Принимает POST данные с параметрами контактной формы и формирует html разметку.
 * 
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class FormsStatic extends FormsTools {

	public function __construct(/*$form_name = '', $notifications=''*/) {

		// Имя формы в формате css
		//$this->options['form_name'] = $form_name;
		// Имя формы в формате php
		//$this->options['array_name'] = str_replace( '-', '_', $this->options['form_name'] );

		// Уведомления
		//$this->notifications = $notifications;

		// Крючек статической контактной формы
		add_action( 'get_static_contact_form', [$this, 'get_static_contact_form'], 1, 1 );

		// Крючек статической контактной формы
		add_filter( 'return_static_contact_form', [$this, 'return_static_contact_form'], 1, 1 );
	}


	/**
	 * Формирование контактной формы (вывод).
	 * Оберткка для получения результата работы.
	 *
	 * @param string
	 * @return string
	 */
	public function get_static_contact_form($form) {
		// Инициализация
		$this->run($form);
		// Вывод результата
		echo $this->get_html();
	}


	/**
	 * Формирование контактной формы (возврашение результата).
	 * Оберткка для получения результата работы.
	 *
	 * @param string
	 * @return string
	 */
	public function return_static_contact_form($form) {
		// Инициализация
		$this->run($form);
		// Возврат результата
		return $this->get_html();
	}


	/**
	 * Инициализация.
	 * Общие инструменты формирование контактной формы.
	 *
	 * @param string
	 * @return void
	 */
	private function run($form) {
		// Имя формы в формате php
		$this->options['array_name'] = $form;
		// Имя формы в формате css
		$this->options['form_name'] = str_replace( '-', '_', $this->options['array_name'] );
		// Назначение формы
		$this->options['purpose'] = 'static';
		// Пути
		$this->path_construct();
		// Родительский конструктор
		FormsKernel::__construct();
	}


	/**
	 * Обработка файла содержащего html обертку контактной формы.
	 */
	protected function get_form_wrapper() {

		// Поиск шаблона (определяется в конфиге)
		if( isset($this->options['template']) && $this->options['template'] != '' ) {
			$template = $this->options['template'];
		} else {
			$template = 'static_form';
		}

		// Проверка наличия файла с шаблоном модального окна
		$this->check_file_path('/view/forms/', $template . '.php');

		// Получение html разметки из файла
		$incubator = file_get_contents($this->files_path[$template]);

		return $incubator;
	}

	/**
	 * Построение массива замен маркеров для контактной формы.
	 */
	protected function get_replacement() {

		// Массив имен уведомлений
		$notifications = array('missed', 'email', 'unknown', 'success');
		// Получение разметки
		$notifications = $this->emergency_notifications($notifications);
		/**
		 * Массив с информацией для замены.
		 * Индексы массива совпадают с маркерами в файлах с элементами разметки.
		 */
		$replacement = array();
		// Определение стандартных значений
		$replacement['form_name'] = $this->options['form_name'];
		$replacement['static_layer_id'] = $this->options['form_name'] . '-form';
		$replacement['form_id'] = 'send-' . $this->options['form_name'] . '-form';
		$replacement['form_title'] = $this->options['form_title'];
		$replacement['mail_title'] = $this->options['mail_title'];
		$replacement['button_title'] = $this->options['button_title'];
		// Уведомления (Получение разметки)
		$replacement['notifications'] = $notifications;

		return $replacement;
	}

} // end FormsStatic