<?php
/**
 * Построение модального окна
 * 
 * Серверная часть ajax приложения
 * Принимает POST данные с параметрами модального окна и формирует html разметку.
 * 
 * @author veselka.ua
 * @version 0.37
 *
 * @package veselka_ua/themes
 */

class FormsModal extends FormsTools {

	public function __construct(&$phones = false) {

		// Проверка наличия имени формы в массиве POST
		if( !isset($_POST['form_name']) ) {
			throw new Exception('No form specification!' );
		}

		/**
		 * Объект телефонов.
		 */
		if( $phones && is_object($phones) ) {
			$this->phones = $phones;
		}
		// Имя формы в формате css
		$this->options['form_name'] = htmlspecialchars($_POST['form_name']);
		unset($_POST['form_name']);
		// Имя формы в формате php
		$this->options['array_name'] = str_replace( '-', '_', $this->options['form_name'] );
		// Наличие модального окна с сообщением об успехе
		$this->options['form_success'] = htmlspecialchars($_POST['form_success']);
		unset($_POST['form_success']);
		// Назначение формы
		$this->options['purpose'] = 'modal';
		// Пути
		$this->path_construct();

		// Родительский конструктор (не для TYP)
		if( $this->options['form_name'] != 'form-success' ) {
			FormsKernel::__construct();
		}

		/**
		 * Подключение шаблона сообщения об успехе.
		 */
		$this->success_template();
	}


	/**
	 * Обработка файла содержащего html обертку контактной формы.
	 */
	protected function get_form_wrapper() {
		// Поиск шаблона (определяется в конфиге)
		if( isset($this->options['template']) && $this->options['template'] != '' ) {
			$template = $this->options['template'];
		} else {
			$template = 'modal_form';
		}

		// Проверка наличия файла с шаблоном модального окна
		$this->check_file_path('/view/forms/', $template . '.php');

		// Получение html разметки из файла
		$incubator = file_get_contents($this->files_path[$template]);

		return $incubator;
	}

	/**
	 * Построение массива замен маркеров для модального окна.
	 */
	protected function get_replacement() {

		// Массив имен уведомлений
		$notifications = array('missed', 'email', 'unknown', 'success');
		// Получение разметки
		$notifications = $this->emergency_notifications($notifications);

		/**
		 * Массив с информацией для замены.
		 * Индексы массива совпадают с маркерами в файлах с элементами разметки.
		 */
		$replacement = [];

		// Определение стандартных значений
		$replacement['form_name'] = $this->options['form_name'];
		$replacement['modal_layer_id'] = $this->options['form_name'] . '-form';
		$replacement['modal_size'] = '';
		$replacement['form_id'] = 'send-' . $this->options['form_name'] . '-form';
		$replacement['form_title'] = $this->options['form_title'];
		$replacement['mail_title'] = $this->options['mail_title'];
		$replacement['button_title'] = $this->options['button_title'];
		$replacement['close_title'] = __('Close','spiral');

		// Уведомления
		$replacement['notifications'] = $notifications;

		// Размер формы
		if( isset($this->options['modal_size']) && is_string($this->options['modal_size']) ) {
			$replacement['modal_size'] = ' modal-' . $this->options['modal_size'];
		}

		// Форма входа
		if( $this->options['array_name'] == 'modal_login' ) {
			$replacement['logo'] = TEMPLATE_URL . '/assets/img/logo_login.svg';
		}

		// Список телефонов
		if( $this->options['array_name'] == 'modal_phones_list' ) {
			$replacement['phones'] = $this->get_phones_list();
		}

		// Быстрый заказ
		$replacement['order'] = '';
		if( $this->options['array_name'] == 'modal_order' ) {
			$replacement['order'] = $this->fields_html['products_container'];
		}

		// Корзина
		if( $this->options['array_name'] == 'modal_cart' ) {
			$replacement = array_merge_recursive( $replacement, $this->get_cart_replacement() );
		}

		return $replacement;
	}


	/**
	 * Обработка файла содержащего окно сообщениея об успехе.
	 */
	private function success_template() {
		// Путь к файлу разметки модального окна с сообщением об успехе
		if( $this->options['form_success'] == 'load' ) {
			// Проверка наличия файла с шаблоном
			$this->check_file_path('/view/forms/', 'modal_success.php');
			$this->check_file_path('/view/forms/', 'part_success_line.php');
			$this->check_file_path('/view/forms/', 'part_success_ico.php');
			// Получение html разметки модального окна из файла
			$incubator = file_get_contents($this->files_path['modal_success']);
			$line = file_get_contents($this->files_path['part_success_line']);
			$ico = file_get_contents($this->files_path['part_success_ico']);
			// Получение текстов из параметров
			$replacement = [
				'typ_title'			=>	get_option('typ_title'),
				'typ_rem'			=>	get_option('typ_rem'),
				'typ_primary'		=>	get_option('typ_primary'),
				'typ_line1'			=>	get_option('typ_line1'),
				'typ_line2'			=>	get_option('typ_line2'),
				'typ_line3'			=>	get_option('typ_line3'),
				'close_title'		=>	__('Close','spiral'),
			];
			// Оформление строк
			foreach( $replacement as $key => $text ) {
				if( $key == 'typ_title' ) {
					// Нет текста
					if( $text == '' ) {
						$text = __('Thank you for your message!', 'spiral' );
					}
					continue;
				}
				// Нет текста
				if( $text == '' ) {
					continue;
				}
				$line_ico = get_option($key.'_ico');
				if( $line_ico != '' ) {
					$line_ico = $this->markers_replacement($ico,['typ_ico'=>$line_ico]);
				}
				// Замены
				$line_replacement = [
					'typ_ico'	=>	$line_ico,
					'typ_line'	=>	$text,
					'typ_class'	=>	in_array($key,['typ_primary'])?' text-primary':'',
				];
				// Шаблон линии текста
				$replacement[$key] = $this->markers_replacement($line,$line_replacement);
			}
			// Результат
			$this->result_set .= $this->markers_replacement($incubator,$replacement);
		}
	}


	/**
	 * Формирование разметки телефонов.
	 */
	private function get_phones_list() {
		$result_set = '';
		$this->phones->get_load();
		$this->check_file_path('/view/contacts/', 'phone_number.php');
		// Сортировка телефонов
		if( get_option('public_contacts_sort') ) {
			$phones = $this->phones->get_sorted_array();
			if( !$phones || empty($phones) ) {
				return '';
			}
			$this->check_file_path('/view/forms/', 'part_block_title.php');
			foreach( $phones as $phone_block ) {
				$incubator = file_get_contents($this->files_path['part_block_title']);
				$incubator = str_replace('[BLOCK_TITLE]', $phone_block['title'], $incubator);
				$result_set .= $incubator;
				foreach( $phone_block['ids'] as $key ) {
					$result_set .= $this->get_phones_layout($this->phones->data[$key]);
				}
			}
		// Несортированыне телефоны
		} else {
			foreach( $this->phones->data as $phone ) {
				$result_set .= $this->get_phones_layout($phone);
			}
		}
		return $result_set;
	}


	/**
	 * Формирование разметки телефонов.
	 * Вспомогательынй метод, формирующий разметку одного телефона
	 */
	private function get_phones_layout($phone) {
		// Телефон как есть?
		if( (bool)get_option('public_phones_view') ) {
			$number	= $phone['as_is'];
		} else {
			$number	= $phone['phone_sanitized'];
		}
		// Замены маркеров
		$incubator = file_get_contents($this->files_path['phone_number']);
		$incubator = str_replace('[%PHONE_CLEANED%]', $phone['phone_cleaned'], $incubator);
		$incubator = str_replace('[%PHONE_TITLE%]', $phone['translate'], $incubator);
		$incubator = str_replace('[%ICO%]', $phone['ico'], $incubator);
		$incubator = str_replace('[%MICRODATA%]', '', $incubator);
		$incubator = str_replace('[%PHONE_HTML%]', $number, $incubator);

		return $incubator;
	}


	/**
	 * Формирование массива замен для корзины.
	 * Вспомогательынй метод, массив замен для формы с корзиной
	 */
	private function get_cart_replacement() {

		return [
			// Нет товаров
			'no_orders'				=> 	__('At the moment, you have no orders','shop'),
			// Загловки
			'header_img'			=> 	__('Model','shop'),
			'header_title'			=> 	__('Name','shop'),
			'header_price'			=> 	__('Price','shop'),
			'header_manage'			=> 	__('Management','shop'),
			// Общая цена
			'price_total_title'		=> 	__('Total price','shop') . ':',
			'quantity_total_title'	=> 	__('Total quantity','shop') . ':',
			'pcs'					=> 	__('pcs.','shop'),
			'currency'				=> 	__('UAH','shop'),
			// Заготовка товара
			'cart_item'				=> 	$this->get_cart_item(),
			// Кнопки управления
			'download_title'		=> 	__('Save shopping cart','shop'),
			'upload_title'			=> 	__('Upload shopping cart','shop'),
			'erase_title'			=> 	__('Delete all from the cart','shop'),
		];
	}


	/**
	 * Формирование разметки элемента корзины.
	 * Вспомогательынй метод, формирующий разметку заготовка для обработки в JS
	 */
	private function get_cart_item() {

		// Массив замен
		$replacement = [
			'id_marker'				=>	'id-marker',
			'item_id'				=>	'',
			'style'					=>	' style="display:none;"',
			'num'					=>	'#',
			'outer_src'				=>	'',
			'outer_title'			=>	'',
			'inner_src'				=>	'',
			'inner_title'			=>	'',
			'name'					=>	'',
			'outer_name'			=>	'',
			'inner_name'			=>	'',
			'price'					=>	'',
			'currency'				=>	'',
			'pdf_href'				=>	get_home_url() . '/pdf/item/',//SHOP_DIR_URL . '/inc/pdf.php',
			'link_to_return'		=>	'',
			'decrement_cart_item'	=>	__('Decrement quantity','shop'),
			'quantity_title'		=>	__('Quantity','shop'),
			'increment_cart_item'	=>	__('Increment quantity','shop'),
			'pdf_cart_item'			=>	__('Order Info','shop'),
			'return_cart_item'		=>	__('Write parameters to the calculator','shop'),
			'erase_cart_item'		=>	__('Delete Item','shop'),
		];

		// Проверка наличия файла с шаблоном элемента корзины
		$this->check_file_path('/view/forms/', 'part_cart_item.php');
		// Получение html разметки из файла
		$result_set = file_get_contents($this->files_path['part_cart_item']);
		// Замена
		foreach( $replacement as $id => $translate ) {
			$result_set = str_replace('[%'.strtoupper($id).'%]', $translate, $result_set);
		}

		return $result_set;
	}

} // end FormsModal