<?php
/**
 * Инструменты повышения продаж (формы контактов, заказа и пр. в виде модальных окон).
 * 
 * Результаты работы данно класса - полуфабрикаты для построения контактных форм.
 *
 * TODO:
 * 1. Переместить все методы в kernel.class.php
 * 2. Переделать в прототип
 * 3. Переместить методы из form_tools в kernel.class.php
 * 4. Заменить методы наследуемых классов на методыобщего объекта
 *
 * @author veselka.ua
 * @version 0.35
 *
 * @package veselka_ua/themes
 */

abstract class FormsKernel {


	use PluginsPath;

	/**
	 * Массив параметров
	 */
	protected $options = [];
	/**
	 * Массив POST после обработки.
	 */
	protected $post_data = [];
	/**
	 * Список полей текущей контактной формы.
	 */
	protected $fields = [];
	/**
	 * Названия полей.
	 */
	protected $labels = [];
	/**
	 * Подсказки полей.
	 */
	protected $placeholders = [];
	/**
	 * Результат работы.
	 */
	protected $result_set;
	/**
	 * Лог работы для выброса в JS.
	 * Отладочный механизм, содержимое будет показано в модальном окне, при удачной отправке письма.
	 * $this->logs .= "\n" . 'input_text_assembly: ' . $argument;
	 *
	 * @type string
	 */
	protected $logs = '';
	/**
	 * Пути к файлам.
	 */
	protected $files_path = [];


	public function __construct() {

		// Проверка наличия плагина
		// Плагины могут быть дочерними (частными случаями)
		// Имена констрант с путями могут совпадать для разных имен плагинов
		$this->check_plugins();

		/**
		 * Получение и обработка входных данных.
		 * 
		 * Метод дочернего объекта.
		 * Для каждого дочернего объекта свои механизмы.
		 */
		$this->input_data_processing();

		if( empty($this->post_data) && isset($this->static_form) && $this->static_form ) {
			return false;
		}

		/**
		 * Получение текстовой информации (названия полей, подсказки).
		 */
		$this->registry['txt_data'] = false;
		$this->get_txt_data();

		/**
		 * Плучение параметров текущей контктной формы.
		 */
		$this->get_form_data();

		/**
		 * Обработка данных для получени реузьтата работы.
		 * 
		 * Метод дочернего объекта.
		 * Для каждого дочернего объекта свои механизмы.
		 */
		$this->result_construct();

	}

//////////////////// Публичные методы ////////////////////

	/**
	 * Обертка для получения результата.
	 */
	final public function get_html() {
		return $this->result_set;
	}

	/**
	 * Обертка для получения лога работы объекта.
	 */
	final public function get_logs() {
		return $this->logs;
	}

//////////////////// Абстрактные методы ////////////////////

	/**
	 * Обработка входной информации.
	 */ 
	abstract protected function input_data_processing();

	/**
	 * Обработка информации и построение результата.
	 */ 
	abstract protected function result_construct();

	/**
	 * Построение разметки заголовка блока полей.
	 */ 
	abstract protected function block_header_construct($block_title);

	/**
	 * Построение разметки для текущего одиночного поля (поля формы или строки письма).
	 */ 
	abstract protected function single_line_construct($incoming_value, $lable, $lable_name, $block_name);

	/**
	 * Построение обертки для сформированного результата.
	 */ 
	abstract protected function html_wrapper_construct($result_set);

//////////////////// Приватные и защищенные методы ////////////////////


	/**
	 * Путь к файлам
	 */
	protected function path_construct() {
		// Определение где был создан объект и запись пути к файлам шаблона
		if( !defined( 'TEMPLATEPATH' ) ) {
			// AJAX
			$this->options['template_dir'] = '..';
		} else {
			// WP
			$this->options['template_dir'] = TEMPLATEPATH;
		}
	}

	/**
	 * Проверка файлов.
	 * 
	 * Если файл существует путь записывается в массив.
	 * Дальнейшее обращение к файлу через элемент массива с индексом равным имени фала.
	 *
	 * В качестве аргументов принимается часть пути от корня шаблона до файла и имя файла.
	 */
	protected function check_file_path($sub_path, $file_name) {

		// Если не указан путь - искать файл в корне
		if( !$sub_path ) {
			$sub_path = '/';
		}
		// Проверка наличия имени файла
		if( !$file_name ) {
			return false;
		}
		// Поиск расширения
		$ext = explode('.', $file_name);
		$index = $ext[0];
		
		// Проверка наличия файла с названиями полей
		$file_path = $this->options['template_dir'] . $sub_path . $file_name;
		// Исключение (нет файла)
		if( !file_exists($file_path) ) {
			throw new Exception('File error: ' . $file_path);
		} else {
			$this->files_path[$index] = $file_path;
		}
	}


	/**
	 * Обработка POST данных и запись в локальный массив.
	 */
	protected function post_data_handling($form_name_prefix) {
		if( isset($_POST) && !empty($_POST) ) {
			// Резервирование данных
			foreach( $_POST as $key => $value ) {
				// Удаление префикса из имени поля
				$short_key = explode($form_name_prefix, $key);
				// Возможны ли тут исключения? Все что без префикса - лесом.
				if( isset($short_key[1]) ) {
					$short_key = $short_key[1];
					// Отсеивание технических данных
					if ($short_key != 'question' && $short_key != 'form-name' ) {
						// Запись значений полей в локальный массив
						$this->post_data[$short_key] = htmlspecialchars($value, ENT_NOQUOTES, 'UTF-8');
					}
				}
			}
			if( !isset($this->static_form) || !$this->static_form ) {
				unset($_POST);
			}
		}
	}


	/**
	 * Подключение файла с текстовой информацией.
	 * 
	 * Массив содержит названия полей и подсказки к полям.
	 * Информация сортирована тематически по блокам.
	 */
	private function get_txt_data() {
		// Уже загружалось
		if( $this->registry['txt_data'] ) {
			return true;
		}

		// Проверка наличия файла с названиями полей
		$file = '/conf/fields.php';
		$file_custom = '/conf/fields_custom.php';

		// Пути
		$path = ['theme'=>TEMPLATEPATH];
		// Пути к плагинам
		$path = array_merge_recursive($path,$this->plugins_path);

		// Итерация путей
		foreach( $path as $key => $sub_path ) {
			$file_path = $sub_path . $file;
			$file_path_custom = $sub_path . $file_custom;

			// Исключение (нет основного файла)
			if( $key == 'theme' && !file_exists($file_path) ) {
				throw new Exception('File error: ' . $file_path);
			}

			// Подключение файла с именами полей.
			if( file_exists($file_path) ) {
				require_once $file_path;
			}
			if( file_exists($file_path_custom) ) {
				require_once $file_path_custom;
			}
		}

		/**
		 * Сортировка згруженного массива по назначению.
		 * Результатом работы будет два массива (Названий полей и подсказок) с одинаковыми индексами.
		 */
		foreach( $fields as $names_block => $text_data ) {
			// Выделение имани и суффикса блока
			$tmp = explode('_', $names_block);
			$block_name = $tmp[0];
			$block_suffix = $tmp[1];

			foreach( $text_data as $field_name => $value ) {
				// Имя свойства равно имени суффикса labels/placeholders
				$this->{$block_suffix}[$block_name][$field_name] = $value;
			}
		}

		$this->registry['txt_data'] = true;
	}


	/**
	 * Параметры формы.
	 * 
	 * Подключение конфигурационного файла с параметрами форм.
	 * Выбор массива происходит по переданному имени формы.
	 */
	private function get_form_data() {

		// Проверка наличия файла с параметрами форм
		$file = '/conf/forms.php';
		$file_custom = '/conf/forms_custom.php';

		// Пути
		$path = ['theme'=>TEMPLATEPATH];
		// Пути к плагинам
		$path = array_merge_recursive($path,$this->plugins_path);

		// Итерация путей
		foreach( $path as $key => $sub_path ) {
			$file_path = $sub_path . $file;
			$file_path_custom = $sub_path . $file_custom;

			// Исключение (нет основного файла)
			if( $key == 'theme' && !file_exists($file_path) ) {
				throw new Exception('File error: ' . $file_path);
			} 			

			// Подключение файла с именами полей.
			if( file_exists($file_path) ) {
				require $file_path;
			}
			if( file_exists($file_path_custom) ) {
				require $file_path_custom;
			}
		}

		// Проверка наличия параметров контактной формы
		if( !isset(${$this->options['array_name']}) || empty(${$this->options['array_name']}) ) {
			throw new Exception('There is no form parametrs! Array: ' . $this->options['array_name']);
		}

		// Запись заголовков контактной формы
		foreach(${$this->options['array_name']}['titles'] as $key => $value) {
			$this->options[$key] = $value;
		}

		// Удаление элементов не являющимися описанием полей формы (заголовки)
		unset(${$this->options['array_name']}['titles']);

		// Запись параметров формы как свойства объекта
		$this->fields = ${$this->options['array_name']};

		// Проход циклом по массиву параметров для восстановления параметров по умолчанию
		foreach( $this->fields as $name => $options ) {
			// Нет массива параметров поля
			if( !is_array($options) ) {
				// Запись значения по умолчанию
				$this->fields[$name] = [];
			}
			// Нет параметра типа поля
			if( !isset($options['type']) ) {
				// Запись значения по умолчанию
				$this->fields[$name]['type'] = $defaults['type'];
			}
		}
	}


	/**
	 * Преобразование данных в необходимый вид.
	 * 
	 * Сборка данных в единое целое и добавление html разметки.
	 */
	protected function html_construct($incoming_data) {

		// Массив для сортировки полей по блокам
		// Каждый отдельный блок записывется в элемент массива
		$result_set = [];

		// (1) Проход цикла по массиву входных даннх
		foreach( $incoming_data as $incoming_name => $incoming_value ) {
			// (2) Проход цикла по массивам текстовых значений (названий полей) для поиска совпадений индексов массивов
			foreach( $this->labels as $block_name => $text_data ) {
				// (3) Проход цикла по массиву названий полей для поиска совпадений
				foreach( $text_data as $lable_name => $lable ) {
					// Совпадение индексов массивов пост данных и имен полей
					if( $incoming_name == $lable_name ) {
						// Проверка сущесвования временной переменной (первый проход цикла или нет)
						if( !isset( $result_set[$block_name] ) ) {
							// Создание элемента массива для хранения блока полей
							$result_set[$block_name] = '';
							if( $this->fields[$lable_name]['type'] != 'hidden' ) {
								// Запись заголовка
								$result_set[$block_name] .= $this->block_header_construct($text_data['block_title']);
							}
						}

						// Запись значения
						$result_set[$block_name] .= $this->single_line_construct($incoming_value, $lable, $lable_name, $block_name);
					} // end if
				} // end foreach (3)
			} // end foreach (2)
		} // end foreach (1)

		// Оформление результата
		$this->html_wrapper_construct($result_set);
	}

} // end FormsKernel
?>