<?php
/**
 * Телефоны.
 * 
 * Парсинг телефонов из базы.
 *
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class ContactsPhones extends ContactsGet {

	/**
	 * Регистр - флаги и данные необходимые для работы.
	 * @type array
	 */
	public $registry = [];
	/**
	 * Счетчик телефонов.
	 * @type int
	 */
	public $length = 0;


	public function __construct() {
		// Флаг инициализации объекта
		$this->registry['instance'] = false;
		// Хук получения телефон в виде строки
		add_filter( 'txt_phone_construct', [$this, 'get_one_txt_string'] );
		// Хук получения телефон в виде строки для SEO
		add_filter( 'seo_phone_construct', [$this, 'get_one_seo_string'] );
	}


//////////////////// Публичные методы ////////////////////


	/**
	 * Обертка для инициализации.
	 *
	 * @param void
	 * @return string
	 */
	public function get_load() {
		// Инициализация
		$this->load();
	}


	/**
	 * Основной телефон виде массива параметров.
	 *
	 * @param void
	 * @return array
	 */
	public function get_one_array() {
		// Вывод результата
		if( $this->load() ) {
			return $this->the_one_phone_array();
		}
	}


	/**
	 * Основной телефон в виде строки.
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_string() {
		// Вывод результата
		if( $this->load() ) {
			return $this->the_one_phone_string();
		}
	}


	/**
	 * Основной телефон в виде строки.
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_txt_string() {
		// Вывод результата
		if( $this->load() ) {
			return $this->the_one_phone_seo();
		}
	}


	/**
	 * Основной телефон в виде строки для SEO (значек телефона UTF8).
	 *
	 * @param void
	 * @return string
	 */
	public function get_one_seo_string() {
		// Вывод результата
		if( $this->load() ) {
			return $this->the_one_phone_seo(true);
		}
	}


	/**
	 * Список идентификаторов телефонов сортированных по подписи.
	 *
	 * @param void
	 * @return array
	 */
	public function get_sorted_array() {
		// Вывод результата
		if( $this->load() ) {
			return $this->the_sorted_array();
		}
	}


//////////////////// Приватные методы ////////////////////


	/**
	 * Получение телефонов из параметров WP.
	 *
	 * @param void
	 * @return void
	 */
	private function load() {
		// Если индикатор сущности ложь, объкт не вызывался
		if( $this->registry['instance'] ) {
			return true;
		}
		// Массив иконок
		$options = [
			'phone_number'		=>	'fa-phone',
			'phone_number2'		=>	'fa-phone',
			'phone_number3'		=>	'fa-phone',
			'fax_number'		=>	'fa-fax',
			'mobile_number'		=>	'fa-mobile',
			'mobile_number2'	=>	'fa-mobile',
			'mobile_number3'	=>	'fa-mobile',
		];
		$translates = [
			'phone_number'		=>	__('Landline telephone number', 'spiral' ),
			'phone_number2'		=>	__('Landline telephone number', 'spiral' ),
			'phone_number3'		=>	__('Landline telephone number', 'spiral' ),
			'fax_number'		=>	__('Fax number', 'spiral' ),
			'mobile_number'		=>	__('Mobile phone number', 'spiral' ),
			'mobile_number2'	=>	__('Mobile phone number', 'spiral' ),
			'mobile_number3'	=>	__('Mobile phone number', 'spiral' ),
		];
		$middle_html	=	')</span>' . ' ' . '<span class="phone-number-value">';
		$start_html		=	'<span class="phone-city-code">(';
		$finish_html	=	'</span>';
		// Количество телефонов
		$counter = 0;
		// Тлефоны из параметров
		foreach( $options as $key => $ico ) {

			$phone = get_option('public_'.$key);
			if( !$phone ) {
				continue;
			}
			// Очистка
			$phone_cleaned = (string)str_replace( ['-','_','(',')',' '], '', $phone );
			$phone_sterile = (string)str_replace( '+38', '', $phone_cleaned );
			// Если количество цифр не совпадает - не продолжаем
			if( strlen($phone_sterile) != 10 ) {
				continue;
			}
			// Количество телефонов
			$counter++;
			// Форматированный телефон (цифры и сиволы)
			$phone_sanitized	=	'(' .
								substr($phone_sterile, 0, 3) .
								') ' .
								substr($phone_sterile, 3, 3) .
								'-' .
								substr($phone_sterile, 6, 2) .
								'-' .
								substr($phone_sterile, 8, 2);
			// Форматированный телефон с html тегами
			$phone_html	= 		$start_html .
								substr($phone_sterile, 0, 3) .
								$middle_html .
								substr($phone_sterile, 3, 3) .
								'-' .
								substr($phone_sterile, 6, 2) .
								'-' .
								substr($phone_sterile, 8, 2) .
								$finish_html;
			// Как есть
			$phone_as_is	=	(string)str_replace( '  ', ' ', $phone );
			$phone_as_is	=	trim($phone_as_is);
			$phone_as_is_html=	$phone_as_is;
			if( mb_strpos($phone_as_is_html,'(') !== false && mb_strpos($phone_as_is_html,')') !== false ) {
				$phone_as_is_html	=	(string)str_replace( '(', $start_html, $phone_as_is_html );
				$phone_as_is_html	=	(string)str_replace( ') ', ')', $phone_as_is_html );
				$phone_as_is_html	=	(string)str_replace( ')', $middle_html, $phone_as_is_html );
				$phone_as_is_html	=	$phone_as_is_html . $finish_html;
			}
			// Запись результата
			$this->data[$key]['phone_cleaned']	=	$phone_cleaned;
			$this->data[$key]['phone_sanitized']=	$phone_sanitized;
			$this->data[$key]['phone_html']		=	$phone_html;
			$this->data[$key]['as_is']			=	$phone_as_is;
			$this->data[$key]['as_is_html']		=	$phone_as_is_html;
			$this->data[$key]['ico']			=	$ico;
			$this->data[$key]['translate']		=	$translates[$key] . ' - ' . get_bloginfo('name');
			$this->data[$key]['sign']			=	(string)get_option('public_'.str_replace('_number','',$key).'_txt');
			$this->data[$key]['key']			=	$key; // Телефон передан через сортировку, узнать индекс в глобальном массиве
		}

		// Количество телефонов
		$this->length = $counter;
		// Инициализация завершена
		$this->registry['instance'] = true;
		return true;
	}


	/**
	 * Получение телефона.
	 * Поиск хотябы одного телефона, кроме факса.
	 * Сначала выборка стационарных, если их нет, то мобильных.
	 *
	 * @param void
	 * @return array|false
	 */
	private function the_one_phone_array() {
		// Значения по умаолчанию
		$master['phone'] = false;
		$master['mobile'] = false;
		// Нет телефонов
		if( empty($this->data) ) {
			return '';
		}
		// Поиск
		foreach( $this->data as $key => $phone ) {
			$type = explode( '_', $key );
			$type = $type[0];
			if( isset($master[$type]) && $master[$type] === false ) {
				$master[$type] = $phone;
			}
		}
		// Возврат результата
		if( $master['phone'] !== false ) {
			return $master['phone'];
		} else  {
			return $master['mobile'];
		}
	}


	/**
	 * Основной телефон в виде строки.
	 *
	 * @param void
	 * @return string
	 */
	private function the_one_phone_string() {
		$result_set = '';
		// Если хоть один телефон существует
		$master_phone = $this->the_one_phone_array();
		if( $master_phone && is_array($master_phone) ) {
			// Номер как есть?
			if( (bool)get_option('public_phones_view') ) {
				$result_set .= $master_phone['as_is'];
			} else {
				$result_set .= $master_phone['phone_cleaned'];
			}
		}
		return $result_set;
	}


	/**
	 * Основной телефон для SEO.
	 *
	 * @param bool $prefix
	 * @return string
	 */
	private function the_one_phone_seo($prefix=false) {
		$result_set = '';
		// Если хоть один телефон существует
		$master_phone = $this->the_one_phone_array();
		if( $master_phone && is_array($master_phone) ) {

			$result_set = $prefix?'☎ ':'';
			// Номер как есть?
			if( (bool)get_option('public_phones_view') ) {
				$result_set .= $master_phone['as_is'];
			} else {
				$result_set .= $master_phone['phone_sanitized'];
			}
		}
		return $result_set;
	}


	/**
	 * Сортированный список идентификаторов телфонов.
	 *
	 * @param void
	 * @return array
	 */
	private function the_sorted_array() {
		$result_set = [];
		$i = 0;
		foreach($this->data as $key => $phone) {
			// Нет подписи, не записывать
			if( $phone['sign'] == '' ) {
				continue;
			}
			// Поиск ключа, array_search не подходит
			$current_key = false;
			if( !empty($result_set) ) {
				foreach( $result_set as $sorted_key => $result ) {
					if( $result['title'] == $phone['sign'] ) {
						$current_key = $sorted_key;
						break;
					}
				}
			}
			// Первое вхождение
			if( $current_key === false ) {
				// Используется первый попавшийся ключ основного массива (они уникальны)
				$current_key = $i;
				$i++;
				// Запись заголовка
				$result_set[$current_key]['title'] = $phone['sign'];
			}
			// Запись идетификатора
			$result_set[$current_key]['ids'][] = $key;
		}
		// Результат
		return $result_set;
	}


} // end ContactsPhones
?>