<?php
/**
 * Социальные кнопки.
 * 
 * Формирует разметку соцкнопок из указанных в админке адресов.
 *
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class ContactsGeneratorSocial {


	use FileHandling, TemplatesLoad;

	/**
	 * Объект соцкнопок.
	 * @type obj
	 */
	private $social_networks;
	/**
	 * Массив параметров.
	 * @type array
	 */
	private $options;
	/**
	 * Результат работы.
	 * @type string
	 */
	private $result_set;


	public function __construct( &$social_networks = false ) {

		/**
		 * Объект почтовых адресов.
		 */
		if( $social_networks && is_object($social_networks) ) {
			$this->social_networks = $social_networks;
		}

		// Инициализация
		$this->load();

		// Cоцкнопки в меню.
		add_action( 'social_networks_nav', [$this, 'get_social_networks_nav'], 1, 0 );
		// Cоцкнопки в контактах.
		add_action( 'social_networks_contacts', [$this, 'get_social_networks_contacts'], 1, 0 );
		// Cоцкнопки в футере.
		add_action( 'social_networks_footer', [$this, 'get_social_networks_footer'], 1, 0 );
	}


//////////////////// Публичные методы ////////////////////


	/**
	 * Список соцсетей в верхнем меню.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_social_networks_nav() {
		// Формирование разметки
		$this->set_social_networks();
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Список соцсетей на странице контактов.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_social_networks_contacts() {
		// Формирование разметки
		$this->set_social_networks('contacts');
		// Вывод результата
		echo $this->result_set;
	}


	/**
	 * Список соцсетей в футере.
	 * Оберткка для получения результата работы.
	 *
	 * @param void
	 * @return string
	 */
	public function get_social_networks_footer() {
		// Формирование разметки
		$this->set_social_networks('footer');
		// Вывод результата
		echo $this->result_set;
	}



//////////////////// Приватные методы ////////////////////


	/**
	 * Инициализация.
	 *
	 * @param void
	 * @return void
	 */
	private function load() {
		// Шаблоны разметки для почты
		$this->options['files']['nav']			= 'social_nav.php';
		$this->options['files']['contacts']		= 'social_contacts.php';
		$this->options['files']['footer']		= 'social_footer.php';
		$this->options['files']['ico']			= 'social_ico.php';
		$this->options['files']['ico_stacked']	= 'social_ico_stacked.php';
	}


	/**
	 * Разметка социальнцых сетей.
	 * Разметка для верхнего меню.
	 *
	 * @param string $template
	 * @return void
	 */
	private function set_social_networks($template='nav') {

		// Шаблон обертки соцсетей
		if( !isset($this->options['files'][$template]) ) {
			$this->result_set = '';
			return NULL;
		}

		// Разметка
		$result_set = '';
		foreach( $this->social_networks->data as $social_network ) {
			// Шаблон иконки
			$item = 'ico';
			if( $template=='nav' ) {
				$replacement['ico'] = $social_network['ico'];
			} else {
				$replacement['ico'] = $social_network['square'];
				if( $social_network['stacked'] ) {
					$item = 'ico_stacked';
				}
			}

			// Мессив замен
			$replacement['url']			=	$social_network['url'];
			$replacement['title']		=	$social_network['title'] . ' - ' . get_bloginfo('name');
			// Замена маркеров и запись результата
			$result_set .= $this->template_replacement( $replacement, $item, 'contacts' );
		}
		// Если не пустой список
		if( $result_set != '' ) {
			// Обертка для списка
			$result_set = $this->template_replacement( ['links'=>$result_set], $template, 'contacts' );
		}
		// Результат
		$this->result_set = $result_set;
	}


} // end ContactsGeneratorSocial
?>