<?php
/**
 * Адреса.
 * 
 * Парсинг адресов из базы.
 *
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class ContactsAddress extends ContactsGet {


	/**
	 * Часы работы.
	 * @type array
	 */
	protected $business_hours;
	/**
	 * Полный адрес.
	 * @type array
	 */
	protected $full;


	public function __construct() {
		//Получение адресов из параметров WP.
		$this->load_address();
	}


//////////////////// Публичные методы ////////////////////



//////////////////// Приватные методы ////////////////////


	/**
	 * Получение телефонов из параметров WP.
	 *
	 * @param void
	 * @return void
	 */
	private function load_address() {
		// Предустановки
		$this->full = false;
		$this->data['postal_code']	= false;
		$this->data['localization']	= false;
		$this->data['address']		= false;
		// Свойства микроразметки
		$itemprop = [
			'postal_code'	=>	'postalCode',
			'localization'	=>	'addressLocality',
			'address'		=>	'streetAddress',
		];
		foreach( $itemprop as $key => $value ) {
			
		}
		// Адрес
		$address = get_option('public_address');
		if( (bool)$address ) {
			$this->data['address']['item'] = $address;
			$this->data['address']['type'] = $itemprop['address'];
			$this->full = $address;
		}
		// Локализация
		$localization = get_option('public_localization');
		if( (bool)$localization ) {
			$this->data['localization']['item'] = $localization;
			$this->data['localization']['type'] = $itemprop['localization'];
			if(!empty($this->full)) {
				$this->full = $localization . ', ' . $this->full;
			}
		}
		// Почтовый код
		$postal_code = get_option('public_postal_code');
		if( (bool)$postal_code ) {
			$this->data['postal_code']['item'] = $postal_code;
			$this->data['postal_code']['type'] = $itemprop['postal_code'];
			if(!empty($this->full)) {
				$this->full = $postal_code . ', ' . $this->full;
			}
		}
		// Часы работы
		$this->business_hours = get_option('public_business_hours');
		if( !(bool)$this->business_hours ) {
			$this->business_hours = false;
		}
	}


} // end ContactsAddress
?>