<?php
/**
 * Параметры SEO
 *
 *
 * Основные параметры SEO вынесены в админпанель, подменю "Настройки".
 *
 *
 * @param void
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class AdminOptionsSeo extends AdminOptions {


	public function __construct() {
		/**
		 * Хук для получение объекта с общими методами.
		 */
		add_action( 'seo_options_gui', [$this, 'get_options_gui'], 20, 1 );
		// Префикс
		$this->p = 'seo';
	}


//////////////////// Защищенные методы ////////////////////


	/**
	 * Заголовки.
	 * Используются в родительском объекте для объявления страницы меню.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_page_data() {
		$this->gui->names['seo']['title']		=	__('Seo Settings', 'spiral' );
		$this->gui->names['seo']['menu_title']	=	__('SEO', 'spiral' );
		$this->gui->names['seo']['prefix']		=	'seo';
	}


	/**
	 * Названия и описания секций.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_sections_names() {
		$this->gui->sections['seo'] = [
			'api' => [
				'title'			=> __('Applications keys', 'spiral' ),
				'description'	=> __('The keys for applications, tracking, social networks.', 'spiral' ),
			],
			'metatitle' => [
				'title'			=> __('Document title', 'spiral' ),
				'description'	=> __('Seo title generation parameters of the document based on current site state.', 'spiral' ) . '<br>' . __('Variables', 'spiral' ) . ': ' . '%blog_name% %blog_description% %page_title% %h1% %ancestors% %url% %tel%',
			],
			'metatags' => [
				'title'			=> __('Meta tags options', 'spiral' ),
				'description'	=> __('Parameters of generating meta tags in pages and posts. E.g. description, keywords, canonical.', 'spiral' ) . '<br>' . __('Variables', 'spiral' ) . ': ' . '%blog_name% %blog_description% %page_title% %h1% %ancestors% %url% %tel%',
			],
			'seotaxonomy' => [
				'title'			=> __('Seo in taxonomies', 'spiral' ),
				'description'	=> __('Parameters of generating meta tags in taxonomies.', 'spiral' ),
			],
			'titleprefix' => [
				'title'			=> __('Title prefixes', 'spiral' ),
				'description'	=> __('Prefixes to generate title and meta tags in archives.', 'spiral' ),
			],
			'breadcrumbs' => [
				'title'			=> __('Bread Crumbs', 'spiral' ),
				'description'	=> __('Options and prefixes for generating the navigation unit Bread Crumbs.', 'spiral' ),
			],
			'xmlsitemap' => [
				'title'			=> __('Sitemap xml', 'spiral' ),
				'description'	=> __('Xml sitemap file generating options. Fine tuning options in the object.', 'spiral' ),
			],
		];
	}


	/**
	 * Названия полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_fields_names() {

		// Определени дополнительных полей.
		$this->gui->fields['seo'] = [
			'api_ga'						=>	__('Universal Analitycs ID', 'spiral' ), // 
			'api_gtag'						=>	__('Global Site Tag Analitycs ID', 'spiral' ), // 
			'api_gtm'						=>	__('Google tag manager ID', 'spiral' ), // 
			'api_metrika'					=>	__('Yandex metrika ID', 'spiral' ), // 
			'api_facebook'					=>	__('Facebook application ID', 'spiral' ), // 
			'api_facebook_pixel'			=>	__('Facebook pixel ID', 'spiral' ), // 
			'api_binotel'					=>	__('Binotel ID', 'spiral' ), // 
			'metatitle'						=>	__('Title generation', 'spiral' ), // Заголовок
			'metatitle_page_rule'			=>	__('Pages' ), // Правила генерации заголовка на страницах
			'metatitle_post_rule'			=>	__('Posts' ), // Правила генерации заголовка в записях
			'metatitle_category_rule'		=>	__('Categories' ), // Правила генерации заголовка в рубриках
			'metatitle_products_rule'		=>	__('Products', 'shop' ), // Правила генерации заголовка в товарах
			'metatitle_catalog_rule'		=>	__('Catalog', 'shop' ), // Правила генерации заголовка в категориях товаров
			'metatitle_estate_rule'			=>	__('Estate', 'realty' ), // Правила генерации заголовка в объектах недвижимости
			'metatitle_realty_rule'			=>	__('Realty', 'realty' ), // Правила генерации заголовка в категориях объектов недвижимости
			'metatitle_default_rule'		=>	__('Defaults', 'spiral' ), // Правила генерации заголовка по умолчанию
			'metatags_og'					=>	__('Open Graph', 'spiral' ), // Open Graph
			'metatags'						=>	__('Seo tags', 'spiral' ), // Метатеги
			'metatags_page_rule'			=>	__('Pages' ), // Правила генерации описания на страницах
			'metatags_post_rule'			=>	__('Posts' ), // Правила генерации описания в записях
			'metatags_category_rule'		=>	__('Categories' ), // Правила генерации описания в рубриках
			'metatags_products_rule'		=>	__('Products', 'shop' ), // Правила генерации описания в товарах
			'metatags_catalog_rule'			=>	__('Catalog', 'shop' ), // Правила генерации описания в категориях товаров
			'metatags_estate_rule'			=>	__('Estate', 'realty' ), // Правила генерации описания в объектах недвижимости
			'metatags_realty_rule'			=>	__('Realty', 'realty' ), // Правила генерации описания в категориях объектов недвижимости
			'metatags_default_rule'			=>	__('Defaults', 'spiral' ), // Правила генерации описания о умолчанию
			'seotaxonomy'					=>	__('Taxonomies', 'spiral' ), // SEO в таксономиях
			'titleprefix_tag'				=>	__('Tag archive', 'spiral' ), // Записи с меткой:
			'titleprefix_author'			=>	__('Autor archive', 'spiral' ), // Архив Автора:
			'titleprefix_day'				=>	__('Day archive', 'spiral' ), // Архив за день:
			'titleprefix_month'				=>	__('Month archive', 'spiral' ), // Архив за месяц:
			'titleprefix_year'				=>	__('Year archive', 'spiral' ), // Архив за год:
			'titleprefix_search'			=>	__('Search page', 'spiral' ), // Поиск по сайту:
			'titleprefix_404'				=>	__('404 page', 'spiral' ), // Ошибка 404
			'titleprefix_paged'				=>	__('Pagination', 'spiral' ), // Страница
			'breadcrumbs'					=>	__('Bread Crumbs', 'spiral' ), // Хлебные крошки
			'breadcrumbs_home_anchor'		=>	__('Home anchor (site name by default)', 'spiral' ), // Текст ссылки главной страницы. По умолчанию имя сайта.
			'breadcrumbs_tag'				=>	__('Tag archive', 'spiral' ), // Записи с меткой:
			'breadcrumbs_author'			=>	__('Autor archive', 'spiral' ), // Архив Автора:
			'breadcrumbs_day'				=>	__('Day archive', 'spiral' ), // Архив за день:
			'breadcrumbs_month'				=>	__('Month archive', 'spiral' ), // Архив за месяц:
			'breadcrumbs_year'				=>	__('Year archive', 'spiral' ), // Архив за год:
			'breadcrumbs_search'			=>	__('Search page', 'spiral' ), // Поиск по сайту:
			'breadcrumbs_404'				=>	__('404 page', 'spiral' ), // Ошибка 404
			'breadcrumbs_paged'				=>	__('Pagination', 'spiral' ), // Страница
			'xmlsitemap'					=>	__('Sitemap', 'spiral' ), // Карта сайта xml
		];
	}


	/**
	 * Названия множественных полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_sub_fields_names() {
		$this->gui->sub_fields['seo'] = [
			'api_ga'	=>	[
				0	=>	'', // txt
			],
			'api_gtag'	=>	[
				0	=>	'', // txt
			],
			'api_gtm'	=>	[
				0	=>	'', // txt
			],
			'api_metrika'	=>	[
				0	=>	'', // txt
			],
			'api_facebook'	=>	[
				0	=>	'', // txt
			],
			'api_facebook_pixel'	=>	[
				0	=>	'', // txt
			],
			'api_binotel'	=>	[
				0	=>	'', // txt
			],
			'metatitle'	=>	[
				0	=>	__('Enabled', 'spiral' ), // Включено
			],
			'metatitle_page_rule'	=>	[
				0	=>	'', // txt
			],
			'metatitle_post_rule'	=>	[
				0	=>	'', // txt
			],
			'metatitle_category_rule'	=>	[
				0	=>	'', // txt
			],
			'metatitle_products_rule'	=>	[
				0	=>	'', // txt
			],
			'metatitle_catalog_rule'	=>	[
				0	=>	'', // txt
			],
			'metatitle_estate_rule'	=>	[
				0	=>	'', // txt
			],
			'metatitle_realty_rule'	=>	[
				0	=>	'' // txt
			],
			'metatitle_default_rule'	=>	[
				0	=>	'' // txt
			],
			'metatags_og'	=>	[
				0	=>	__('Enabled', 'spiral' ), // Включено
			],
			'metatags'	=>	[
				0	=>	__('Enabled tag generation', 'spiral' ), // Включено
				'description'		=>	__('Meta description', 'spiral' ), // Описание
				'keywords'			=>	__('Meta keywords', 'spiral' ), // Ключевые слова
				'robots'			=>	__('Meta robots', 'spiral' ), // Robots
				'canonical'			=>	__('Rel canonical', 'spiral' ), // Canonical
			],
			'metatags_page_rule'	=>	[
				0	=>	'', // txt
			],
			'metatags_post_rule'	=>	[
				0	=>	'', // txt
			],
			'metatags_category_rule'	=>	[
				0	=>	'', // txt
			],
			'metatags_products_rule'	=>	[
				0	=>	'', // txt
			],
			'metatags_catalog_rule'	=>	[
				0	=>	'', // txt
			],
			'metatags_estate_rule'	=>	[
				0	=>	'', // txt
			],
			'metatags_realty_rule'	=>	[
				0	=>	'' // txt
			],
			'metatags_default_rule'	=>	[
				0	=>	'%ancestors% - предки перечисляется через запятую в конце точка и пробел' // txt
			],
			'seotaxonomy'	=>	[
				0	=>	__('Seo gui enabled', 'spiral' ), // Показывать графический интерфейс
				'identical_canonical'		=>	__('Identical canonical link on pagination', 'spiral' ), // Одинаковая каноническая ссылка для всех страниц пагинации кроме главной.
				'noindex_paged_tax'			=>	__('Noindex paged taxonomy', 'spiral' ), // В таксономиях на страницы пагинации (кроме первой) добавляется meta robots = "noindex,follow".
				'noindex_category'			=>	__('Noindex blog categories', 'spiral' ), // Не индексировать рубрики.
				'noindex_catalog'			=>	__('Noindex pgoducts archives', 'spiral' ), // Не индексировать категории товаров.
				'noindex_realty'			=>	__('Noindex realty archives', 'spiral' ), // Не индексировать категории недвижимости.
				'noindex_tag'				=>	__('Noindex tagged archives', 'spiral' ), // Не индексировать теги.
				'noindex_date'				=>	__('Noindex date archive', 'spiral' ), // Не индексировать архивы дат.
				'noindex_author'			=>	__('Noindex author archive', 'spiral' ), // Не индексировать архивы автора.
			],
			'titleprefix_tag'	=>	[
				0	=>	'', // txt
			],
			'titleprefix_author'	=>	[
				0	=>	'', // txt
			],
			'titleprefix_day'	=>	[
				0	=>	'', // txt
			],
			'titleprefix_month'	=>	[
				0	=>	'', // txt
			],
			'titleprefix_year'	=>	[
				0	=>	'', // txt
			],
			'titleprefix_search'	=>	[
				0	=>	'', // txt
			],
			'titleprefix_404'	=>	[
				0	=>	'', // txt
			],
			'titleprefix_paged'	=>	[
				0	=>	'', // txt
			],
			'breadcrumbs'	=>	[
				0	=>	__('Enabled', 'spiral' ), // Включено
				'current'		=>	__('Show current node', 'spiral' ), // Показывать название текущей статьи/страницы/рубрики.
				'home_link'		=>	__('Show home node', 'spiral' ), // Показывать ссылку на главную страницу.
				'title'			=>	__('Show titles on mouse hover', 'spiral' ), // Показывать всплывающцю подсказку - (title) для ссылок.
			],
			'breadcrumbs_home_anchor'	=>	[
				0	=>	'', // txt
			],
			'breadcrumbs_tag'	=>	[
				0	=>	'', // txt
			],
			'breadcrumbs_author'	=>	[
				0	=>	'', // txt
			],
			'breadcrumbs_day'	=>	[
				0	=>	'', // txt
			],
			'breadcrumbs_month'	=>	[
				0	=>	'', // txt
			],
			'breadcrumbs_year'	=>	[
				0	=>	'', // txt
			],
			'breadcrumbs_search'	=>	[
				0	=>	'', // txt
			],
			'breadcrumbs_404'	=>	[
				0	=>	'', // txt
			],
			'breadcrumbs_paged'	=>	[
				0	=>	'', // txt
			],
			'xmlsitemap'	=>	[
				0	=>	__('Enabled', 'spiral' ), // Включено
				'debug'		=>	__('Debug mode, write map on save too', 'spiral' ), // Режим отладки.
				'se_ping'		=>	__('Search engines ping', 'spiral' ), // Оповещение поисковиков.
				'stylesheet'		=>	__('Use stylesheet file for ease of use', 'spiral' ), // Устанавливаем стили отображения XML карты.
			],
		];
	}


	/**
	 * Типы полей.
	 *
	 * @param void
	 * @return void
	 */
	protected function set_fields_types() {
		$this->gui->fields_type['seo'] = [
			'api_ga'							=>	'text',
			'api_gtag'							=>	'text',
			'api_gtm'							=>	'text',
			'api_metrika'						=>	'text',
			'api_facebook'						=>	'text',
			'api_facebook_pixel'				=>	'text',
			'api_binotel'						=>	'text',
			'metatitle'							=>	'checkbox',
			'metatitle_page_rule'				=>	'text',
			'metatitle_post_rule'				=>	'text',
			'metatitle_category_rule'			=>	'text',
			'metatitle_products_rule'			=>	'text',
			'metatitle_catalog_rule'			=>	'text',
			'metatitle_estate_rule'				=>	'text',
			'metatitle_realty_rule'				=>	'text',
			'metatitle_default_rule'			=>	'text',
			'metatags_og'						=>	'checkbox',
			'metatags'							=>	'checkbox',
			//'metatags_description'				=>	'checkbox',
			//'metatags_keywords'					=>	'checkbox',
			//'metatags_robots'					=>	'checkbox',
			//'metatags_canonical'				=>	'checkbox',
			'metatags_page_rule'				=>	'text',
			'metatags_post_rule'				=>	'text',
			'metatags_category_rule'			=>	'text',
			'metatags_products_rule'			=>	'text',
			'metatags_catalog_rule'				=>	'text',
			'metatags_estate_rule'				=>	'text',
			'metatags_realty_rule'				=>	'text',
			'metatags_default_rule'				=>	'text',
			'seotaxonomy'						=>	'checkbox',
			//'seotaxonomy_identical_canonical'	=>	'checkbox',
			//'seotaxonomy_noindex_paged_tax'		=>	'checkbox',
			//'seotaxonomy_noindex_category'		=>	'checkbox',
			//'seotaxonomy_noindex_catalog'		=>	'checkbox',
			//'seotaxonomy_noindex_realty'		=>	'checkbox',
			//'seotaxonomy_noindex_tag'			=>	'checkbox',
			//'seotaxonomy_noindex_date'			=>	'checkbox',
			//'seotaxonomy_noindex_author'		=>	'checkbox',
			'titleprefix_tag'					=>	'text',
			'titleprefix_author'				=>	'text',
			'titleprefix_day'					=>	'text',
			'titleprefix_month'					=>	'text',
			'titleprefix_year'					=>	'text',
			'titleprefix_search'				=>	'text',
			'titleprefix_404'					=>	'text',
			'titleprefix_paged'					=>	'text',
			'breadcrumbs'						=>	'checkbox',
			//'breadcrumbs_current'				=>	'checkbox',
			//'breadcrumbs_home_link'				=>	'checkbox',
			//'breadcrumbs_title'					=>	'checkbox',
			'breadcrumbs_home_anchor'			=>	'text',
			'breadcrumbs_tag'					=>	'text',
			'breadcrumbs_author'				=>	'text',
			'breadcrumbs_day'					=>	'text',
			'breadcrumbs_month'					=>	'text',
			'breadcrumbs_year'					=>	'text',
			'breadcrumbs_search'				=>	'text',
			'breadcrumbs_404'					=>	'text',
			'breadcrumbs_paged'					=>	'text',
			'xmlsitemap'						=>	'checkbox',
			//'xmlsitemap_debug'					=>	'checkbox',
			//'xmlsitemap_se_ping'				=>	'checkbox',
			//'xmlsitemap_stylesheet'				=>	'checkbox',
		];
		$this->gui->fields_class['seo'] = [
			'metatitle_page_rule'				=>	'large-text',
			'metatitle_post_rule'				=>	'large-text',
			'metatitle_category_rule'			=>	'large-text',
			'metatitle_products_rule'			=>	'large-text',
			'metatitle_catalog_rule'			=>	'large-text',
			'metatitle_estate_rule'				=>	'large-text',
			'metatitle_realty_rule'				=>	'large-text',
			'metatitle_default_rule'			=>	'large-text',
			'metatags_page_rule'				=>	'large-text',
			'metatags_post_rule'				=>	'large-text',
			'metatags_category_rule'			=>	'large-text',
			'metatags_products_rule'			=>	'large-text',
			'metatags_catalog_rule'				=>	'large-text',
			'metatags_estate_rule'				=>	'large-text',
			'metatags_realty_rule'				=>	'large-text',
			'metatags_default_rule'				=>	'large-text',
		];
		// Скрытые неактивных полей
		$this->gui->hidden['seo'] = [];
		if( !post_type_exists('realty') ) {
			array_push($this->gui->hidden['seo'], 'metatitle_estate_rule','metatitle_realty_rule','metatags_estate_rule','metatags_realty_rule');
		}
		if( !post_type_exists('products') ) {
			array_push($this->gui->hidden['seo'], 'metatitle_products_rule','metatitle_catalog_rule','metatags_products_rule','metatags_catalog_rule');
		}
	}


} // end AdminOptionsSeo
?>