<?php
/**
 * Общий метод содержаций функции обратного вызова.
 *
 * Используются для формирования полей на страницах параметров.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

class AdminOptionsCallback {

	/**
	 * Ниаменование страницы параметров.
	 * @type array
	 */
	public $names = [];
	/**
	 * Имена и описания секций.
	 * @type array
	 */
	public $sections = [];
	/**
	 * Префиксы дополнительных полей.
	 * @type array
	 */
	public $fields = [];
	/**
	 * Дополнительные параметры.
	 * @type array
	 */
	public $sub_fields = [];
	/**
	 * Типы полей.
	 * @type array
	 */
	public $fields_type = [];
	/**
	 * Типы полей.
	 * @type array
	 */
	public $fields_class = [];
	/**
	 * Скрытые поля.
	 * @type array
	 */
	public $hidden = [];


	public function __construct() {

		/**
		 * Передача текущего объекта в фильтр по ссылке для объктов использующих общие методы
		 */
		$recipients = ['template','seo','general','gdrive','syp','commerce','hotels'];
		foreach( $recipients as $recipient ) {
			if( has_action( $recipient.'_options_gui' ) ) {
				do_action_ref_array( $recipient.'_options_gui', [&$this] );
			}
		}

	}


	/**
	 * Добавить новую страницу.
	 *
	 * @param string $prefix
	 * @return void
	 */
	final public function add_admin_page($prefix) {

		if( !current_user_can( 'manage_options' ) )  {
			wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
		}

		// Добавит страницу меню в меню "Настройки"
		add_options_page(
			$this->names[$prefix]['title'],
			$this->names[$prefix]['menu_title'],
			'manage_options',
			$this->names[$prefix]['prefix'] . '-setting-admin',
			function() use( &$prefix) {
				?>
				<div class="wrap">
					<h1><?php echo $this->names[$prefix]['title']; ?></h1>
					<form method="post" action="options.php">
					<?php
						// Вывод необходимых полей
						settings_fields( $this->names[$prefix]['prefix'] . '_options' );
						do_settings_sections( $this->names[$prefix]['prefix'] . '-setting-admin' );
						submit_button();
					?>
					</form>
				</div>
				<?php
			}
			//[$this, 'create_admin_page'] // Callback
		);
	}


	/**
	 * Добавление новых полей.
	 *
	 * @param string $page
	 * @return void
	 */
	final public function add_option_field_to_admin_page($page) {

		/**
		 * Создание новых секций.
		 */
		foreach( $this->sections[$page] as $suffix => $section ) {

			add_settings_section(
				'setting_section_' . $suffix, // ID
				$section['title'], // Title
				function($args){
					$page = '';
					foreach( $this->sections as $key => $section ) {
						if( array_key_exists( str_replace('setting_section_', '', $args['id']), $section ) ) {
							$page = $key;
						}
					}
					echo $this->sections[$page][str_replace('setting_section_', '', $args['id'])]['description'];
					// $section[str_replace('setting_section_', '', $section['id'])]['description'];
				}, // Callback with description
				$this->names[$page]['prefix'] . '-setting-admin' // Page (used global prefix)
			);
		}

		/**
		 * Создание новых полей.
		 */
		foreach( $this->fields[$page] as $option_name => $option_title ) {
			/**
			 * Регистрация дополнительных полей.
			 */
			if( !isset($this->sub_fields[$page][$option_name]) ) {
				$this->sub_fields[$page][$option_name] = [0=>''];
			}
			foreach( $this->sub_fields[$page][$option_name] as $index => $sub_option_title ) {
				if( $index === 0 || $this->fields_type[$page][$option_name] == 'radio' ) {
					$index = '';
				} else {
					$index = '_' . $index;
				}
				register_setting( $this->names[$page]['prefix'] . '_options', $option_name . $index );
				if( $this->fields_type[$page][$option_name] == 'radio' ) {
					break;
				}
			}
			// Скрытые поля
			if( !empty($this->hidden) && isset($this->hidden[$page]) && in_array( $option_name, $this->hidden[$page] ) ) {
				continue;
			}
			// Идентификатор
			$id = 'veselka_' . $option_name;
			$prefix = explode('_',$option_name);
			$section = 'setting_section_'.$prefix[0];

			// Добавление дополнительных полей в меню.
			add_settings_field(
				$id,
				$option_title,
				[$this, 'setting_callback_'.$this->fields_type[$page][$option_name].'_list'], // Callback
				$this->names[$page]['prefix'].'-setting-admin', // Page
				$section, // Section
				[
					'id'			=>	$id,
					'option_name'	=>	$option_name,
					'page'		=>	$page, // ? prefix
				]
			);
		}
	}


	/**
	 * Функция обратного вызова.
	 *
	 * Функция заполняет поле нужным <input type="text"> тегом, который станет частью одной большой формы.
	 *
	 * @param array $val
	 * @return echo
	 */
	final public function setting_callback_text_list( $val ) {
		$name		=	$val['option_name'];
		$page		=	$val['page'];
		$class		=	'regular-text';
		if( isset($this->fields_class[$val['page']][$name]) ) {
			$class	=	$this->fields_class[$val['page']][$name];
		}

		?>
		<fieldset>
		<input
			type="text"
			name="<?php echo $val['option_name']; ?>"
			id="<?php echo $val['id']; ?>"
			value="<?php echo get_option($name); ?>"
			class="<? echo $class; ?>"
		/>
			<?php echo ($this->sub_fields[$page][$name][0] != '')?'<p class="description">'.$this->sub_fields[$page][$name][0].'</p>':''; ?>
		</fieldset>
		<?php
	}


	/**
	 * Функция обратного вызова.
	 *
	 * Функция заполняет поле нужным <input type="checkbox"> тегом, который станет частью одной большой формы.
	 *
	 * @param array $val
	 * @return echo
	 */
	final public function setting_callback_checkbox_list( $val ) {
		$name		=	$val['option_name'];
		$page		=	$val['page'];
		?>
		<fieldset>
		<?php
		foreach( $this->sub_fields[$page][$name] as $index => $sub_option_title ) {
			if( $index !== 0 ) {
				$option_name = $name . '_' . $index;
			} else {
				$option_name = $name;
			}
			$id = 'veselka_' . $option_name;
			?>
			<label for="<?php echo $id; ?>">
				<input
					name="<?php echo $option_name; ?>"
					id="<?php echo $id; ?>"
					type="checkbox"
					value="1"
					class="code"
					<?php checked( '1', get_option( $option_name ), true ); ?>
				><?php echo $sub_option_title; ?>
			</label>
			<br>
			<?php
		}
		?>
		</fieldset>
		<?php
	}


	/**
	 * Функция обратного вызова.
	 *
	 * Функция заполняет поле нужным <input type="radio"> тегом, который станет частью одной большой формы.
	 *
	 * @param array $val
	 * @return echo
	 */
	final public function setting_callback_radio_list( $val ) {
		$name		=	$val['option_name'];
		$page		=	$val['page'];
		?>
		<fieldset>
		<?php
		foreach( $this->sub_fields[$page][$name] as $index => $sub_option_title ) {
		$id = 'veselka_' . $name . '_' . $index;
		?>
			<label for="<?php echo $id; ?>">
				<input
					name="<?php echo $name; ?>"
					id="<?php echo $id; ?>"
					type="radio"
					value="<?php echo $index; ?>"
					class="code"
					<?php checked( $index, get_option($name), true ); ?>
				><?php echo $sub_option_title; ?>
			</label>
			<br>
		<?php
		}
		?>
		</fieldset>
		<?php
	}


} // end AdminOptionsCallback
?>