<?php
/**
 * Интерфейс содержащий общие методы.
 *
 * Используются для формирования полей на страницах параметров.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

abstract class AdminOptions {

	/**
	 * Префикс листа.
	 * @type string
	 */
	protected $p;
	/**
	 * Функции обратного вызова для формирования полей на страницах параметров.
	 * @type obj
	 */
	protected $gui;



//////////////////// Публичные методы ////////////////////


	/**
	 * функция хука для получения общего объекта по ссылке.
	 *
	 * Функции обратного вызова для формирования параметров.
	 *
	 * @param object $options_gui
	 * @return void
	 */
	final public function get_options_gui( $options_gui ){
		// Объект с общими методами передан?
		if( $options_gui && is_object($options_gui) ) {
			// Объект в локальное свойство
			$this->gui = $options_gui;
			/**
			 * Добавление новой страницы меню.
			 */
			add_action( 'admin_menu', [$this, 'add_admin_page'] );
			/**
			 * Добавление полей в меню.
			 */
			add_action( 'admin_init', [$this, 'add_option_field_to_admin_page'] );
		}
	}


	/**
	 * Добавить новую страницу.
	 *
	 * @param void
	 * @return void
	 */
	final public function add_admin_page() {

		// Название страницы
		$this->set_page_data();

		/**
		 * Добавление новой страницы меню.
		 */
		$this->gui->add_admin_page($this->p);
	}


	/**
	 * Добавление новых полей.
	 *
	 * @param void
	 * @return void
	 */
	final public function add_option_field_to_admin_page() {

		// Наименование секций
		$this->set_sections_names();
		// Имена полей
		$this->set_fields_names();
		// Дополнитльные поля
		$this->set_sub_fields_names();
		// Типы полей ввода данных
		$this->set_fields_types();

		/**
		 * Добавление полей в меню.
		 */
		$this->gui->add_option_field_to_admin_page($this->p);
	}


//////////////////// Абстрактые методы ////////////////////


	/**
	 * Названия и описания секций.
	 *
	 * @param void
	 * @return void
	 */
	abstract protected function set_page_data();
	/**
	 * Названия и описания секций.
	 *
	 * @param void
	 * @return void
	 */
	abstract protected function set_sections_names();
	/**
	 * Названия полей.
	 *
	 * @param void
	 * @return void
	 */
	abstract protected function set_fields_names();
	/**
	 * Названия множественных полей.
	 *
	 * @param void
	 * @return void
	 */
	abstract protected function set_sub_fields_names();
	/**
	 * Типы полей.
	 *
	 * @param void
	 * @return void
	 */
	abstract protected function set_fields_types();


} // end AdminOptions
?>