<?php
/**
 * Все настройки и установки SEO происходят в этом файле.
 *
 * Все необходимые для работы экземпляры объектов из каталога lib/seo/ создаются в этом файле.
 * 
 *  
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */


/**
 * SEO модуль.
 */
if( (bool)get_option('common_seo') ) {

	if( is_admin() ) {

		/**
		 * SEO интерфейс в таксономиях.
		 */
		if( (bool)get_option('seotaxonomy') ) {
			$seo_admin = new SeoAdmin();
		}

		/**
		 * XML карта сайта.
		 */
		if( (bool)get_option('xmlsitemap') ) {
			$seo_xml_sitemap = new SeoSitemap();
		}

	} else {

		/**
		 * Родительская библиотека.
		 */
		$semantic_kernel = new SeoSemantic();

		/**
		 * Заголовок <title> - переопределение wp_title().
		 */
		if( (bool)get_option('metatitle') ) {
			$seo_title = new SeoTitle( $semantic_kernel );
		}

		/**
		 * Конструктор seo тегов (description, keywords, canonical, robots).
		 */
		if( (bool)get_option('metatags') ) {
			$seo_mata_tags = new SeoMeta( $semantic_kernel );
		}

		/**
		 * Конструктор Open Graph метатегов.
		 */
		if( (bool)get_option('metatags_og') ) {
			$seo_open_graph = new SeoOpengraph( $semantic_kernel );
		}

		/**
		 * Хлебные крошки.
		 */
		if( (bool)get_option('breadcrumbs') ) {
			$seo_breadcrumbs = new SeoBreadcrumbs( $semantic_kernel );
		}

		/**
		 * Очистка контента (Закрывает внешние ссылки в noindex).
		 */
		$seo_cleaner = new SeoCleaner();

	}

}

/**
 * Заголовок H1.
 * Работает даже при отключенном SEO
 */
$seo_heading = new SeoHeading( $semantic_kernel );

?>