<?php
/**
 * Обработка контакной информации заданной в админпанели.
 *
 * Все необходимые для работы экземпляры объектов из каталога lib/contscts/ создаются в этом файле.
 * 
 *  
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */


/**
 * Обработка публичных данных: телефоны, адреса, почта.
 */
if( !is_admin() ) {

	/**
	 * Получение данных.
	 */
	$phones = new ContactsPhones();
	$emails = new ContactsEmails();
	$address = new ContactsAddress();
	$social = new ContactsSocial();

	/**
	 * Формирвание разметки контактных данных.
	 */
	$phones_generator = new ContactsGeneratorPhones( $phones, $emails );
	$emails_generator = new ContactsGeneratorEmails( $emails );
	$social_generator = new ContactsGeneratorSocial( $social );
	$address_generator = new ContactsGeneratorAddress( $address, $phones, $emails );
}

?>