<?php
/**
 * Инструменты админпанели.
 *
 * Экземпляры объектов из каталогов lib/admin/ создаются в этом файле.
 *
 * 1. Веншний вид админпанели.
 * 2. Настройки сайта.
 * 3. Доп. функционал таксономий.
 * 
 *  
 * @author veselka.ua
 * @version 2.04b
 *
 * @package veselka_ua/themes
 */


/**
 * Получение параметров доступа к настройкам шаблона.
 */
$options = new AdminConfig();

/**
 * Пользователькие настройки внешнего вида админпанели.
 */
$admin_tuning = new AdminTuning();

/**
 * Добавление параметров сайта.
 */
if( is_admin() ) {

	/**
	 * Параметры шаблона.
	 */
	if( !in_array($options->mode, ['prod','strict']) ) {
		$themplate_options = new AdminOptionsTemplate();
	}

	/**
	 * SEO параметры в админпанели.
	 */
	if( (bool)get_option('common_seo') && $options->mode != 'strict' ) {
		$seo_options = new AdminOptionsSeo();
	}

	/**
	 * Публичные данные.
	 */
	if( $options->mode != 'strict' ) {
		$general_options = new AdminOptionsGeneral();
	}

	/**
	 * Параметры загрузки из GDrive.
	 */
	if( (bool)get_option('common_gdrive') && $options->mode != 'strict' ) {
		$gdrive_options = new AdminOptionsGdrive();
	}


	/**
	 * Коммерция.
	 */
	if( (bool)get_option('common_commerce') ) {
		$commerce_options = new AdminOptionsCommerce();
	}

	/**
	 * Общие объект с функциями обратного вызова.
	 */
	$callback_options = new AdminOptionsCallback();
}

/**
 * Дополнительные поля в таксономиях.
 */
if( is_admin() ) {

	/**
	 * Поля для сортировки в таксономиях.
	 */
	$tax_sorting = new AdminTaxSorting();

	/**
	 * Дополнительные поля в категориях (стандартная таксономия WP).
	 */
	$tax_category = new AdminTaxCategory();

	/**
	 * Библиотека для работы с интерфесом категорий (дополнительные поля).
	 */
	$tax_kernel = new AdminTaxKernel();

}

?>