<?php
/**
 * Autoloader for template classes.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

spl_autoload_register( __NAMESPACE__.'\\veselka_autoloader' );

/**
 * Autoload plugin classes.
 *
 * Callback for spl_autoload_register().
 *
 * @see http://php.net/manual/en/function.spl-autoload-register.php
 *
 * @param  string $class The class name.
 * @return void
 */

function veselka_autoloader( $class ) {

	// Разбиваем имя класса на слова
	$path = preg_split('/(?=[A-Z])/',$class);
	unset($path[0]);

	// Конструктор пути
	$file_path = '/lib';
	foreach( $path as $key => $name ) {
		$file_path .= '/' . strtolower($name);
		if( !isset($path[$key+1]) ) {
			$file_path .= '.class.php';
		}
	}

	// Подключение
	if( file_exists( TEMPLATEPATH . $file_path ) ) {
		require_once TEMPLATEPATH . $file_path;
	}

}

?>