<?php
/**
 * Параметры отправки почтовых сообщений.
 * 
 * Реализовано в виде php массивов. В дальнейшем возможна разрабтка веб интерфейса.
 * Обрабатывается экземпляром объекта MarketingSendMail. Без промежуточного инструмента обработки параметров.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

/**
 * Основные параметры работы обработчика контактных форм.
 * 
 * Элементы данного массива могут принимать значения boolean|string.
 */
$general = array(
	'show_empty' => false, // Заносить в тело письма заголовки незаполненных полей
	'content-type' => 'text/html',
	'charset' => 'utf-8',
	'customer_name' => 'Site Robot', // Поле отправителя: true(указанное имя)|string(указать свой)
	'customer_email' => 'noreply@' . $_SERVER["SERVER_NAME"], // Поле отправителя: true(указанный email)|string(указать свой)
	'show_titles' => true, // Показывать заголовки блоков
	//'mime' => true, // Показывать заголовки блоков
	//'transfer_encoding' => 'base64', // Показывать кодирование
	//'x_mailer' => 'Veselka Send Mail', // Программа отправки письма
	'reply_to' => true, // Адресс для ответа указать адресс почты или false
);

/**
 * Значения по умолчанию для отправки письма.
 *
 * Используется для записи значений по умолчанию.
 * Элементы данного массива могут принимать значения string.
 */
$defaults = array(
	//'to' => 'info@veselka.od.ua', // Почтовый ящик получателя по умолчанию
	'subject' => '[ШАБЛОН]', // Суффикс темы сообщения
	'result_set' => '', // Суффикс сообщени
);
?>