<?php
/**
 * Параметры шаблона.
 * 
 * Реализовано в виде php массивов. В дальнейшем возможна разрабтка веб интерфейса.
 * Обрабатывается экземпляром объекта WpLibConstruct.
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

/**
 * Формирование списка JS библиотек
 *
 * Опции могут иметь следующие значения:
 *  true 
 *  false
 *  script.js - имя файла с расширением, будет загружен из каталога по умолчанию
 * 	http://example.com/dir/script.js - URL файла может быть использовано для загрузки скрипта с CDN сервера
 */
$js = [
	// Библиотеки совместимости для IE
    'html5shiv'			=> 'https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js',
    'respond'			=> 'https://oss.maxcdn.com/respond/1.4.2/respond.min.js',
	// Библиотека JQuery
    'jquery'			=> 'https://ajax.googleapis.com/ajax/libs/jquery/2.2.4/jquery.min.js',
    // JS Bootstrap
    'bootstrap-cdn'		=> 'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js',
	// Библиотека для комментариев
    'comment-reply'		=> true,
	// Пользовательские скрипты для всего сайта
	'common'			=> true,
];

/**
 * Формирование списка CSS библиотек
 *
 * Опции могут иметь следующие значения:
 *  true
 *  false
 *  style.css - имя файла с расширением, будет загружен из каталога по умолчанию
 * 	http://domain.com/dir/style.css - URL файла может быть использовано для загрузки стилей с CDN сервера
 * 
 * Обязательный для вордпресс файл style.css в корне шаблона будет загружен автоматически
 */
$css = [
    // CSS Bootstrap
    'bootstrap'			=> true,
    'bootstrap-theme'	=> true,
	'font-awesome'		=> 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css',
	// Основные файлы стилей
    'common'			=> true,
];

/**
 * Список CSS библиотек для отложенной загрузки.
 */
$delayed = [
	'bootstrap',
	'bootstrap-theme',
	//'_common',
	//'products',
	//'marketing_tools',
	//'help_buttons',
	//'modal_form',
	//'highslide',
	//'highslide-with-gallery',
	//'highslide.mobile',
	//'owl.carousel',
	//'owl.gallery',
	//'map.multiple',
	//'comment-reply',
	//'sidebars',
	//'realty',
	//'realty.search',
	//'font-awesome',
];

?>