<?php
/**
 * Шаблон комментариев
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/themes
 */

// Do not delete these lines
	if( !empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']) )
		die ('Please do not load this page directly. Thanks!');

	if( post_password_required() ) { ?>
		<p class="nocomments">Эта страница защищена паролем.</p>
	<?php
		return;
	}
?>

					<section id="comment-block">
					<?php if( 'open' == $post->comment_status ) { ?>
						<div id="respond" class="respond">
							<h3><?php comment_form_title( 'Оставить комментарий', 'Оставить комментарий для %s' ); ?></h3>
							<div class="cancel-comment-reply">
								<small><?php cancel_comment_reply_link(); ?></small>
							</div>
						
						<?php if( get_option('comment_registration') && !$user_ID ) { ?>

							<span class="help-block">Вы должны <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php echo urlencode(get_permalink()); ?>">авторизоваться</a>, чтобы оставить отзыв.</span>
						<?php } else { ?>

							<form id="commentform" class="form-horizontal" role="form" action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post">

								<?php if( $user_ID ) { ?>

								<span class="help-block">Вы вошли как <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account">Выйти &raquo;</a></span>

								<?php } else { ?>

								<div class="form-group">
									<label id="labelauthor" class="col-sm-3 control-label" for="author">Имя<?php if( $req ) { echo '<span class="text-info"> *</span>'; } ?> </label>
									<div class="col-sm-9">
										<input type="text" name="userbuser" class="form-control" id="author" value="<?php echo $comment_author; ?>"  placeholder="Ваше имя, которое будет отображено в комментарии"<?php if( $req ) { echo ' required'; } ?> />
									</div>
								</div>

								<div class="form-group">
									<label id="labeemail" class="col-sm-3 control-label" for="email">E-mail<?php if( $req ) { echo '<span class="text-info"> *</span>'; } ?> </label>
									<div class="col-sm-9">
										<input type="text" name="contact" class="form-control" id="email" value="<?php echo $comment_author_email; ?>"  placeholder="Адрес Вашего почтового ящика"<?php if( $req ) { echo ' required'; } ?> />
										<span class="help-block">Ваш адрес не будет опубликован.</span>
									</div>
								</div>

									<?php if( function_exists('math_comment_spam_protection') ) {
									$mcsp_info = math_comment_spam_protection();
									?>

									<div class="form-group">
										<label for="<?php echo $mcsp_info['fieldname_answer'] ?>" class="col-sm-3 control-label"><?php echo $mcsp_info['operand1'] . ' + ' . $mcsp_info['operand2'] . ' ?<span class="text-info"> *</span>' ?></label>
										<div class="col-sm-9">
											<input type="text" name="<?php echo $mcsp_info['fieldname_answer'] ?>" class="form-control" id="<?php echo $mcsp_info['fieldname_answer'] ?>" value="" placeholder="Введите сумму чисел и подтвердите, что Вы человек" required />
										</div>
									</div>
									<input type="hidden" name="<?php echo $mcsp_info['fieldname_hash'] ?>" value="<?php echo $mcsp_info['result']; ?>" />
									<?php } // endif function_exists... ?>
								<?php } // endif else  ?>
								
								<!--<p><small><strong>XHTML:</strong> You can use these tags: <code><?php echo allowed_tags(); ?></code></small></p>-->
								<div class="form-group">
									<label id="labeurl" class="col-sm-3 control-label" for="comment">Отзыв<?php if( $req ) { echo '<span class="text-info"> *</span>'; } ?></label>
									<div class="col-sm-9">
										<textarea name="comment" class="form-control" id="comment" rows="6" placeholder="Напишите Ваш комментарий"<?php if( $req ) { echo ' required'; } ?>></textarea>
									</div>
								</div>

								<div class="col-sm-offset-3 col-sm-9">
									<p class="muted"><span class="text-info"><strong>*</strong></span> Обязательные для заполнения поля.</p>
								</div>

								<div class="form-group">
									<div class="col-sm-offset-3 col-sm-9">
										<button id="submit" type="submit" class="btn btn-orange" data-loading-text="Отправка сообщения...">Отправить</button>
									</div>
								</div>
								<?php comment_id_fields(); ?>
								<?php do_action('comment_form', $post->ID); ?>
							
							</form>
						
						<?php } // endif ?>
						</div><!-- /#respond -->
					<?php } // endif open ?>
			
					<?php if( have_comments() ) { ?>

						<div id="comments">
							<h3 id="comments-title"><?php comments_number('Нет комментариев', 'Один комментарий', 'Комментариев:  %' );?></h3>

							<ul class="commentlist list-unstyled">
								<?php 
								// Подключение Волкера - содержит класс для формирования правильной структуры комментариев Bootstrap
								require_once TEMPLATEPATH . '/lib/bootstrap_walker_comments.php';
								// Список комментариев
								wp_list_comments( array(
																'style'			=> 'ul',
																'short_ping'	=> true,
																'avatar_size'	=> '64',
																'format'		=> 'html5',
																'walker'		=> new Bootstrap_Comment_Walker(),
															)
								); ?>
							</ul><!-- /.list-unstyled -->

							<?php if( get_comment_pages_count() > 1 && get_option('page_comments') ) { ?>
							<nav>
								<ul class="pager">
									<?php if( get_previous_comments_link() ) { ?>
										<li class="previous"><?php previous_comments_link('&larr; Старые комментарии'); ?></li>
									<?php } ?>
									<?php if( get_next_comments_link() ) { ?>
										<li class="next"><?php next_comments_link('Новые комментарии &rarr;'); ?></li>
									<?php } ?>
								</ul>
							</nav>
							<?php } // endif ?>

						</div><!-- /.comment-list -->
					<?php } // endif have_comments?>

					</section><!-- /#comments -->