/**
 * OWL
 * 
 * Owl gallery setup
 *
 * @author veselka.ua
 * @version 0.2
 * @modify 23-01-2018
 */

var owlGalleryEvents = (function ($) {

	$.owlGallery = {


		/**
		 * Display width
		 */
		width: '',
		/**
		 * Gallery arguments
		 */
		carouselArgs: {},
		/**
		 * Gallery obj
		 */
		carouselArray: {},

		/**
		 * Permits multiple Ajax requests
		 */
		deferred: [],

		/**
		 * Init carousel
		 */
		init: function ()
		{
			/* Carousel */
			this.setCarouselArgs();
			// Initiate owl carousels
			this.carouselActions();
			// Gallery common actions
			this.commonActions();
			
		},


		/**
		 * Common listeners
		 */
		commonActions: function()
		{
			var _this = this;
			var id;

			// Width
			$( window ).load( function()
			{
				_this.width = window.innerWidth;
			});

			// Resize
			$( window ).resize( function()
			{
				// Only width
				if( _this.width != window.innerWidth )
				{
					// New width
					_this.width = window.innerWidth;

					$.each( _this.carouselArray, function() {
						this.trigger('refresh.owl.carousel');
					});
				}
			});

		},


		/**
		 * Set owl carousel arguments
		 */
		setCarouselArgs: function()
		{
			this.carouselArgs.gallerySlide =
			{
				//rtl:true,
				loop:true,
				rewind:false,
				nav:true,
				dots:false,
				autoplay:true,
				autoplayTimeout:5000,
				autoplayHoverPause:true,
				//merge:true,
				//mergeFit:true,
				//lazyLoad:true,
				navText:['<i class="fa fa-angle-left" aria-hidden="true"></i>','<i class="fa fa-angle-right" aria-hidden="true"></i>'],
				margin:10,
				//responsiveClass:true,
				//autoWidth:true,
				//singleItem : true,
				//startPosition:0,
				//callbacks: true,
				//URLhashListener: true,
				items: 1,
				/*responsive:
				{
					0:{
						items:1,
						margin: 0,
					},
					768:{
						items:2,
						margin: 30,
					},
					992:{
						items:2,
						margin: 30,
					},
					1200:{
						items:3,
						margin: 30,
					}
				},*/
			}
		},

		/**
		 * Carousels actions
		 */
		carouselActions: function()
		{
			var _this = this;
			// Hide
			$(document).ready(function()
			{
				//$('.owl-carousel').css({'opacity':'0'});
			});

			$(window).load(function()
			{
				// Init
				_this.initCarousel();
				// Show
				//$('.owl-carousel').css({'opacity':'1'});
			});
		},


		/**
		 * Initiate owl carousels
		 */
		initCarousel: function()
		{
			var _this = this;
			var id;

			/* Gallery carousel init */
			$.each( $('.owl-carousel'), function()
			{

				// Id
				id = $(this).closest('.responsive-carousel').attr('id').replace('-','_');
				_this.carouselArray[id] = $(this);

				// Carousel args in data artibutes
				$.each( $(this).data(), function(index,data)
				{
					//console.log(data);
					_this.carouselArgs.gallerySlide[index] = data;
				});

				// Posts
				if( $(this).closest('.gallery' ).length > 0 )
				{
					_this.carouselArgs.gallerySlide.items = $(this).closest('.gallery' ).data('row');
					_this.carouselArgs.gallerySlide.autoHeight = true;
					_this.carouselArgs.gallerySlide.autoplay = false;
				}

				// Full width gallery
				if( $(this).closest('#full-width-gallery' ).length > 0 )
				{
					_this.carouselArgs.gallerySlide.items = 1;
				}

				// Comments
				if( $(this).closest('#comments-carousel').length > 0 )
				{
					_this.carouselArgs.gallerySlide.autoplay = true;
					_this.carouselArgs.gallerySlide.autoHeight = false;
					_this.carouselArgs.gallerySlide.dots = true;
					_this.carouselArgs.gallerySlide.nav = false;
					_this.carouselArgs.gallerySlide.margin = 50;
				}

				// Hide custom navigation buttons if carousel has less items to show
				if(	typeof _this.carouselArgs.gallerySlide.responsive != 'undefined' &&
					Object.keys(_this.carouselArgs.gallerySlide.responsive).length
				)
				{
					// Check each point
					var currentLength;
					$.each( _this.carouselArgs.gallerySlide.responsive, function(width,args)
					{
						if( window.innerWidth >= width )
						{
							currentLength = args['items'];
						}
					});
					var galleryItems = $('#'+id+' .owl-carousel > div').length;
					if( galleryItems > 0 )
					{
						if( currentLength >= galleryItems )
						{
							_this.carouselArgs.gallerySlide.nav = false;
							_this.carouselArgs.gallerySlide.loop = false;
							_this.carouselArgs.gallerySlide.rewind = false;
							_this.carouselArgs.gallerySlide.autoplay = false;
						}
					}
					//console.log(galleryItems);
					//console.log(currentLength);
				}

				// Run owl carousel
				_this.deferred.push( _this.carouselArray[id].owlCarousel(_this.carouselArgs.gallerySlide) );
				//$('.owl-height').css('height','auto');

/*				// Realty
				if( $(this).closest('#views-gallery, #layout-gallery').length > 0 )
				{
					_this.carouselArgs.gallerySlide.autoplay = false;
					_this.carouselArgs.gallerySlide.autoHeight = true;
					if( $(this).children('div.clearfix').length < 2 )
					{
						_this.carouselArgs.gallerySlide.autoHeight = false;
						_this.carouselArgs.gallerySlide.nav = false;
						_this.carouselArgs.gallerySlide.loop = false;
					}
				}*/

/*				// Home
				if( $(this).closest('#landing-main-carousel, #homepage-carousel' ).length > 0 )
				{

				}*/
			});
		},


	};

})(jQuery);

$(document).ready(function() {
	$.owlGallery.init();
});
