/**
 * Modal Contact Forms
 * 
 * Getting html markup of modal window
 * Check fields filling
 * Send mail call
 * 
 * @author: veselka.ua
 * @version: 2.0
 * @modify: 23-02-2018
 */


var contactFormsEvents = (function ($)
{

	$.contactForms = {


		/**
		 * Form data
		 */
		formName: '',
		modalId: '',
		formId: '',
		/**
		 * Current page info
		 */
		postId: '',
		serviceId: '',
		/**
		 * Fields focusout
		 */
		fieldRequired: '',
		fieldName: '',
		fieldType: '',
		fieldValue: '',
		/**
		 * Hide depend fields
		 */
		checkedFlag: '',
		classList: '',
		/**
		 * Pressing submit
		 */
		btn: '',
		successFlag: true,
		/**
		 * Statuses
		 */
		fieldsMsg: ['error', 'success', 'warning'],
		fieldsGlyph: ['ban-circle', 'ok', 'warning-sign'],
		/**
		 * Strict
		 */
		strictIds: ['modal-login-form','modal-registration-form','modal-password-form'],


		/**
		 * Permits multiple Ajax requests
		 */
		deferred: [],
	

		/**
		 * Verification codes
		 */
		proof:
		{
			save:		'166c4ec6b541f604df0c3f70ecca17ad',
			answer:		'7c7d65d534452cf0568a6ee80ee77244',
		},


		/**
		 * Init Forms
		 */
		initEvents: function ()
		{
			var _this = this;

			// Hide notifications in static forms
			$( window ).load( function()
			{
				_this.hideMsgs();
			});

			// Behavior actions
			this.bahaviorActions();
		},


		/**
		 * Behavior listeners
		 */
		bahaviorActions: function()
		{

			var _this = this;

			/* Pressing modal window call button */
			$('body').on('click.modal-show', '.modal-show', function()
			{
				// If disabled btn
				if( $(this).attr('disabled') == 'disabled' )
				{
					return false;
				}
				// If deferred modal call (Ajax data manipulation before modal call)
				// In this case, the modal window is initiated by calling methods this.initForms(btn) & this.getForm() directly
				if( $(this).hasClass('modal-deferred') )
				{
					return false;
				}
				// If modal already open
				var modalActive = $('.modal.in').attr('id');
				var btn = this;
				if( $('#'+modalActive).length > 0 )
				{
					$('#'+modalActive).modal('hide');
					$('#'+modalActive).on('hidden.bs.modal', function()
					{
						// Get form
						_this.initForms(btn);
						_this.getForm();
					});

				} else {
					_this.initForms(btn);
					_this.getForm();
				}
				
			});

			/* Data validation during filling */
			$('body').on('focusout', '.verification', function()
			{
				_this.initForms(this);
				_this.verificationDuringFilling();
			});

			/* Hides dependent fields */
			$('body').on('click.contact-form', '.checkbox-inline', function()
			{
				if( $(this).closest('form').attr('id') &&  typeof $(this).attr('data-target') != 'undefined' )
				{
					_this.initForms(this);
					_this.hideDependedFields();
				}
			});

			/* Actions by pressing submit */
			$('body').on('click.contact-form', '.modal-submit', function()
			{
				_this.initForms(this);
				_this.sendMail();
			});

			/* Fix padding right bug */
			$('body').on('hidden.bs.modal', function () {
				$('body').css('padding-right', '0');
			});

			/* Fix second opening modal from modal */
			$('body').on('shown.bs.modal', function () {
				if( !$('body').hasClass('modal-open') ) {
					$('body').addClass('modal-open');
					$('body').css('padding-right', '17px');
				}
			})
		},


		/**
		 * Manage events associated modal and static forms
		 */
		initForms: function(element)
		{
			/* Modal window call button */
			if( $(element).hasClass('modal-show') )
			{
				this.modalId = $(element).attr('data-target').slice(1);
				this.formName = this.modalId.replace('-form', '');
				// Current post ID
				this.postId = $(element).closest('article').attr('id');
				// Service Order form management
				if( this.formName === 'modal-service-order' ) {
					this.serviceId = $(element).data('serviceName');
				}
			}

			/* Field focusout */
			if( $(element).hasClass('verification') )
			{
				this.formId = $(element).closest('form').attr('id');
				this.formName = this.formId.replace('send-', '').replace('-form', '');

				this.fieldRequired = $(element).prop('required');
				this.fieldName = $(element).attr('id').replace('input-', '');
				this.fieldType = $(element).attr('type');
				this.fieldValue = $(element).val();
			}

			/* Hide depend fields */
			if( $(element).attr('class') === 'checkbox-inline' )
			{
				this.formId = $(element).closest('form').attr('id');
				this.formName = this.formId.replace('send-', '').replace('-form', '');

				this.checkedFlag = $(element).children('input').prop('checked');
				this.classList = $(element).parent().siblings().attr('class').split(' ');
			}

			/* Pressing submit */
			if( $(element).hasClass('modal-submit') )
			{
				this.formName = $(element).attr('id').replace('-submit', '');
				this.modalId = this.formName + '-form';
				this.formId = 'send-' + this.modalId;

				this.btn = $(element);
				this.successFlag = true;
			}

		},


		/**
		 * Getting html markup success modal window
		 */
		getSuccessForm: function()
		{
			if( !$('#success-modal').length )
			{
				// Data construct
				var data = {};
				data.proof = this.proof.save;
				data.form_name = 'form-success';
				data.form_success = 'load';
				if( $('#success-modal').length )
				{
					data.form_success = 'null';
				}
				// Ajax
				$.ajax({
					url: template_dir+'/ajax/modal_form.php',
					type: 'POST',
					dataType: 'json',
					data: data,
					success: function(response, code)
					{
						if (response)
						{
							$('body').append(response);
						}
						else
						{
							//console.log( code + ' ' + response );
						}
					},
					error: function(response, code)
					{
						console.log( code + ' ' + response );
					}
				});
			}
		},


		/**
		 * Getting html markup modal window
		 * Actions by pressing modal window call button
		 *
		 * @argument bool show
		 */
		getForm: function(show=false)
		{

			if( !$('div').is( '#' + this.modalId ) )
			{
				// Data construct
				var data = {};
				data.proof = this.proof.save;
				data.form_name = this.formName;
				data.form_success = 'load';
				if( $('#success-modal').length )
				{
					data.form_success = 'null';
				}
				// Ajax
				$.ajax({
					url: template_dir+'/ajax/modal_form.php',
					type: 'POST',
					dataType: 'json',
					data: data,
					success: this.formLoaded.bind(this),
					error: function(response, code)
					{
						console.log( response );
					}
				});
			}
			else
			{
				// Finalization forms
				this.formsFinalization();
				// Deffered form show
				if( show )
				{
					$( '#' + this.modalId ).modal('show');
				}
			}
		},


		/**
		 * Actions on receipt html form layout
		 */
		formLoaded: function(response, code, xml)
		{
			if (response)
			{
				$('body').append(response);
				// Finalization forms
				this.formsFinalization();
				// Show modal
				$( '#' + this.modalId ).modal('show');
				// Send event to Analytics (Fom Summon)
				this.sendAnalyticsData();
				// console.log( this.modalId );
				console.log( ' (^_^)ﾉﾞ Form loaded! ID#'+this.modalId );
			}
			else
			{
				console.log( response );
			}
		},


		/**
		 * Finalization forms
		 */
		formsFinalization: function()
		{
			this.hideMsgs();
			this.removeAllStatuses();
			this.hideSlaveFields();
			// Product Order form management
			if( this.formName === 'modal-order' ) {
				this.fastOrderFormFinalization();
			}
			// Service Order form management
			if( this.formName === 'modal-service-order' ) {
				this.serviceOrderFormFinalization();
			}
			// Shopping cart form management
			if( this.formName === 'modal-cart' && typeof $.runCart != 'undefined' ) {
				// Call shopping carl plugin: cart items
				$.runCart.loadCartData();
			}
		},


		/**
		 * Data validation during filling
		 */
		verificationDuringFilling: function()
		{
			if( this.fieldRequired )
			{
				if( this.fieldType === 'email' )
				{
					if( !this.validateEmail( this.fieldValue ) || !this.fieldValue )
					{
						this.changeStatus(-1, this.fieldName);
					}
					else
					{
						this.changeStatus(1, this.fieldName);
					}
				}
				else
				{
					if( this.fieldValue === '' || !this.fieldValue )
					{
						this.changeStatus(-1, this.fieldName);
					}
					else
					{
						this.changeStatus(1, this.fieldName);
					}
				}
			}
			this.checkRequiredNotifications();
		},


		/**
		 * Send mail prepare
		 */
		sendMail: function()
		{

			// Only visible form
			if( !$('#' + this.modalId).hasClass('in') )
			{
				return false;
			}
			// TMP If system forms, no mail need
			if( jQuery.inArray(this.modalId, this.strictIds) !== -1)
			{
				return false;
			}
			this.hideMsgs();
			// Delay for sending visual representation
			btn = this.btn;
			btn.button('loading');
			setTimeout(function()
			{
				$.ajax().always(function ()
				{
					btn.button('reset');
				});
			}, 1000);
			// Data verification
			this.checkAllFields();
			// Hidden fields
			this.getHiddenFields();
			// SYP
			this.getSuccessForm();
			// Send e-mai
			if( this.successFlag )
			{
				// Before send mail methods loaded?
				if( this.formName === 'modal-order' || this.formName === 'modal-cart-order' )
				{
					// Product Order form management
					this.beforeSendMail();
				}
				else 
				{
					// Send mail
					this.sendMailQuery();
				}
			}

		},


		/**
		 * Defered actions before send mail.
		 */
		beforeSendMail: function()
		{
			var _this = this;
			// Defered data save
			if( typeof $.runCart != 'undefined' )
			{
				var prefix = '#input-' + this.formName;
				// User Data
				var post = {};
				post.customer		= $(prefix + '-customer').val();
				post.email			= $(prefix + '-email').val();
				post.phone			= $(prefix + '-phone').val();
				post.delivery		= $(prefix + '-delivery').val();
				post.payment		= '';
				if( $(prefix + '-payment option:selected').val() != 'disabled' ) {
					post.payment	= $(prefix + '-payment option:selected').text();
				}
				post.shipping		= '';
				if( $(prefix + '-shipping option:selected').val() != 'disabled' ) {
					post.shipping	= $(prefix + '-shipping option:selected').text();
				}
				post.installation	= '';
				if( $(prefix + '-installation').is(':checked') ) {
					post.installation	= $(prefix + '-installation').val();;
				}
				post.order_comment	= $(prefix + '-order_comment').val();
				
				//  Write current session order data to db / Write cart data to db
				var cart = true;
				if( this.formName === 'modal-order' ) {
					cart = false;
				}

				$.runCart.writeCartToDb(post,cart,this.postId);
			}
			else
			{
				// Send mail
				this.sendMailQuery();
			}
		},


		/**
		 * Call send mail.
		 */
		sendMailQuery: function()
		{
			var _this = this;
			// Data cunstruct
			var form = $('#' + this.formId).serializeArray();
			var data = {};
			$.each(form, function( i, v ) {
				data[v['name']] = v['value'];
			});
			data.proof = this.proof.save;

			// Ajax - Send mail
			this.ajaxMailRequest(data);
			// Ajax - save form to GDrive
			this.ajaxSaveGDriveRequest(data);

		},


		/**
		 * Send mail data
		 */
		ajaxMailRequest: function(data)
		{
			$.ajax({
				url: template_dir+'/ajax/send_mail.php',
				type: 'POST',
				dataType: 'json',
				data: data,
				success: this.mailSuccess.bind(this),
				error: function(response, code)
				{
					//console.log(response);
					//$('#modal-debug').html(code+response);
					$('#' + _this.formName + '-unknown-output').show();
				}
			});
		},


		/**
		 * Sending data to Google Drive ((╬◣﹏◢))
		 *
		 * @argument obj data
		 *
		 * @return void
		 */
		ajaxSaveGDriveRequest: function(data)
		{
			$.ajax({
				url: template_dir+'/ajax/form_to_gdrive.php',
				type: 'POST',
				dataType: 'json',
				data: data,
				success: function(response, code)
				{
					console.log('((╬◣﹏◢)) Form ~~~~~~~~~~> GDrive');
				},
				error: function(response, code)
				{
					//console.log(response);
					console.log('((╬◣﹏◢)) Error sending data to GDrive' . response);
				}
			});
		},


		/**
		 * Actions on receipt html form layout
		 */
		mailSuccess: function(response, code, xml)
		{
			if(response)
			{
				console.log( ' (^_~)☆ Mail successfully sent! ID#'+this.modalId );
				//console.log(response);
				this.hideMsgs();
				this.removeAllStatuses();
				this.hideSlaveFields();

				$('#' + this.formId ).find('input,textarea').each(function()
				{
					if( $(this).attr('name') == 'form_name' ) {
						return;
					}
					$(this).val('');
				});
				$('#' + this.formId ).find('select').each(function()
				{
					$(this).prop("selectedIndex",0);
				});
				$('#' + this.formName + '-success-output').show();
				/*$('#modal-debug').html(response);*/

				// Send event to Analytics
				this.sendAnalyticsData(true);

				// Show TYP
				var _this = this;
				setTimeout(function()
				{
					// Hide modal
					var flag = _this.formName.split('-');
					if( flag[0] != 'static' ) {
						$('#' + _this.formName + '-form').modal('hide');
					}
					$('#success-modal').modal('show');
				}, 2000);
			}
			else
			{
				$('#' + this.formName + '-email-output').show();
			}
		},


		/*
		 * Send form info to Analytics if object exists
		 */
		sendAnalyticsData: function(send=false)
		{
			// No formname
			if( typeof this.formName == 'undefined' )
			{
				return false;
			}

			// Category
			var category = 'Form Summon';
			if( send )
			{
				category = 'Form Send';
			}

			// Event
			var event = this.formName.split('-'); // Split into words
			for(var i=0; i<event.length; i++)
			{
				// Make first letters big
				event[i] = event[i].substring(0,1).toUpperCase() + event[i].substring(1);
			}
			event = event.join(' ');

			// Label
			var label = window.location.href.split('/'); // Split url
			label = label[label.length-1]; // Url last block
			label = label.replace('.html','').replace('.php',''); // Clean
			label = label.replace('_','-'); // Exception
			label = label.split('-'); // Split into words
			for(var i=0; i<label.length; i++)
			{
				// Make first letters big
				label[i] = label[i].substring(0,1).toUpperCase() + label[i].substring(1);
			}
			label = label.join(' ');

			// Make obj for sennding
			var send = {
				hitType:		'event',
				eventCategory:	category,
				eventAction:	event,
				eventLabel:		label,
				eventValue:		'1'
			};

			// Send info to tag manager if object exists
			if( window['google_tag_manager'] != undefined )
			{
				dataLayer.push(send);
			}

			// Old Analytics
			if( typeof _gaq != 'undefined')
			{
				_gaq.push(['_trackEvent', category, event]);
			}
			// Universal Analytics
			if( typeof ga != 'undefined')
			{
				ga('send', send );
				//console.log(this.formName);
			}
		},


//////////////////// Changing fields appearance ////////////////////


		/**
		 * Changing status of the field
		 */
		changeStatus: function(status, name) 
		{
			if( $('#label-' + name).parent().hasClass('has-feedback') )
			{
				for( var i = 0; i < this.fieldsMsg.length; i++ )
				{
					if( $('#label-' + name).parent().hasClass('has-' + this.fieldsMsg[i]) )
					{
						if(status === -1)
						{
							this.removeStatus( this.fieldsMsg[i], name, this.fieldsGlyph[i], true );
						}
						else
						{
							this.removeStatus( this.fieldsMsg[i], name, this.fieldsGlyph[i], false );
							this.addStatus( this.fieldsMsg[status], name, this.fieldsGlyph[status], false );
						}
					}
				}
			}
			else
			{
				if(status !== -1)
				{
					this.addStatus( this.fieldsMsg[status], name, this.fieldsGlyph[status], true );
				}
			}
		},


		/**
		 * Adding status of the field
		 */
		addStatus: function(status, name, glyph, total)
		{
			if( total )
			{
				$('#label-' + name).parent().addClass('has-feedback');
				$('#input-' + name).after('<span class="glyphicon glyphicon-' + glyph + ' form-control-feedback"></span>');
			}
			else
			{
				$('#input-' + name).next('span').addClass('glyphicon-' + glyph);
			}
			$('#label-' + name).parent().addClass('has-' + status);
		},


		/**
		 * Removing status of the field
		 */
		removeStatus: function(status, name, glyph, total)
		{
			if( total )
			{
				$('#label-' + name).parent().removeClass('has-feedback');
				$('#input-' + name).next('span').remove();
			}
			else
			{
				$('#input-' + name).next('span').removeClass('glyphicon-' + glyph);
			}
			$('#label-' + name).parent().removeClass('has-' + status);
		},


		/**
		 * Removing all statuses of the fields
		 */
		removeAllStatuses: function()
		{
			var _this = this;
			$('input, textarea, select').each( function()
			{
				if( $(this).prop('required') )
				{
					var name = this.id.replace('input-','');
					if( $('#label-' + name).parent().hasClass('has-feedback') )
					{
						for( var i = 0; i < _this.fieldsMsg.length; i++ )
						{
							if( $('#label-' + name).parent().hasClass( 'has-' + _this.fieldsMsg[i]) )
							{
								_this.removeStatus( _this.fieldsMsg[i], name, _this.fieldsGlyph[i], true );
							}
						}
					}
				}
			});
		},


//////////////////// Helpers ////////////////////


		/**
		 * Hides dependent fields
		 */
		hideDependedFields: function()
		{
			var dependedFields = [];
			$.each( this.classList, function(index, item)
			{
				depend = item.split('-');
				if (depend[0] === 'depend')
				{
					dependedFields[dependedFields.length] = depend[1];
				}
			});
			
			for( var i = 0; i < dependedFields.length; ++i  )
			{
				if( this.checkedFlag )
				{
					$('#label-' + this.formName + '-' + dependedFields[i]).parent('div').show();
				}
				else
				{
					$('#label-' + this.formName + '-' + dependedFields[i]).parent('div').hide();
				}
			}
		},


		/**
		 * Email check
		 *
		 * @argument string email
		 */
		validateEmail: function(email)
		{
			var regexp = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;

			if( regexp.test( email ) )
			{
				return true;
			}
			else
			{
				return false;
			}
		},


		/**
		 * Verification all required fields
		 */
		checkAllFields: function()
		{
			var _this = this;
			var success_flag = true;
			/* Fing all items */
			$('input,textarea,select').each(function()
			{
				if( $(this).closest('form').attr('id') === _this.formId && $(this).prop('required') )
				{
					var name = this.id.replace('input-', '');
					var type = $(this).attr('type');
					if( type === 'email' )
					{
						if( !_this.validateEmail( $(this).val() ) || !$(this).val() )
						{
							_this.changeStatus(0, name);
							success_flag = false;
							$('#' + _this.formName + '-email-output').show();
						}
						else
						{
							_this.changeStatus(1, name);
						}
					}
					else
					{
						if( $(this).val() === '' || !$(this).val() )
						{
							_this.changeStatus(0, name);
							success_flag = false;
							$('#' + _this.formName + '-missed-output').show();
						}
						else
						{
							_this.changeStatus(1, name);
						}
					}
				}
			});
			this.successFlag = success_flag;
		},


		/**
		 * Verification all required fields
		 */
		getHiddenFields: function()
		{
			var _this = this;
			$("input[type=hidden]").each(function()
			{
				if( $(this).attr('name') != _this.formName+'-source' )
				{
					return true;
				}
				$(this).val(window.location.href);
			});
		},


		/**
		 * Verification required notifications during form filling
		 */
		checkRequiredNotifications: function()
		{
			var check = false;
			var form_id = this.formId;
			$('.alert').each(function()
			{
				if( $(this).closest('form').attr('id') === form_id && $(this).attr('style') === 'display: block;' )
				{
					check = true;
				}
			});

			/* Data verification after filling with warnings */
			if( check )
			{
				var missed_output = true;
				var email_output = true;
				$('input,textarea,select').each(function()
				{
					if( $(this).closest('form').attr('id') === form_id && $(this).prop('required') )
					{
						var type = $(this).attr('type');
						//console.log(type);
						if( type === 'email' )
						{
							if( $(this).closest('.form-group').hasClass('has-error') )
							{
								email_output = false;
							}
						}
						else
						{
							if( $(this).closest('.form-group').hasClass('has-error') )
							{
								missed_output = false;
							}
						}
					}
				});

				if( missed_output )
				{
					$('#' + this.formName + '-missed-output').hide();
				}

				if( email_output )
				{
					$('#' + this.formName + '-email-output').hide();
				}
			}
		},


		/**
		 * Hide all messages
		 */
		hideMsgs: function()
		{
			$('.missed-output').hide();
			$('.email-output').hide();
			$('.unknown-output').hide();
			$('.success-output').hide();
		},


		/**
		 * Hide all slave fields
		 */
		hideSlaveFields: function()
		{
			$('.slave-field').parent('div').hide();
		},


		/**
		 * Finalization of the order form
		 */
		serviceOrderFormFinalization: function()
		{
			if( !this.serviceId )
			{
				this.serviceId = 'disabled';
			}
			this.serviceId = this.serviceId.split('-').join('_');
			$("#input-modal-service-order-service option[value="+this.serviceId+"]").attr("selected", true);
		},


		/**
		 * Finalization of the order form
		 */
		fastOrderFormFinalization: function()
		{
			// Replacement values of the catalog
			var productID = this.postId.split('-');
			productID = 'oder-product-' + productID[productID.length-1];
			// Product wrapper
			if( $('div').is( '.product-container' ) )
			{
				$( '.product-container' ).empty();
				$( '.product-container' ).html('');
				$( '.product-container' ).remove();
			}
			$( '<div id="' + productID + '" class="product-container"></div>' ).prependTo( $( '#products-order-container' ) );
console.log(this.postId);
			// Check if shopping plugin exists
			if( typeof $.runProducts != 'undefined' )
			{
				// Add content from shopping plugin
				var poduct = $.runProducts.resurectItemOptions(this.postId);
			}
			else
			{
				// Add content from local method
				var poduct = this.resurectItemOptions();
				// Form actions
				this.orderFormActions();
			}
			// Add current product options to form
			$( poduct ).appendTo( $( '#'+productID ) );
		},


		/**
		 * Add product content to the order form
		 *
		 * @return string poduct
		 */
		resurectItemOptions: function()
		{
			var imgSrc = $('article#'+ this.postId).find('.wp-post-image').attr('src');
			var entryTitle = $('article#'+ this.postId).find('.entry-title').text();
			var priceLabel = $('article#'+ this.postId).find('.price-label').text();
			var priceTotalLabel = $('article#'+ this.postId).find('.price-label').data('totalLabel');
			var priceValue = $('article#'+ this.postId).find('.price-value').text();
			var priceContent = $('article#'+ this.postId).find('.price-value').attr('content');
			var priceCurrency = $('article#'+ this.postId).find('.price-currency').text();
			var quantity = $('article#'+ this.postId).find('.price-value').data('quantity');

			if( typeof quantity == 'undefined' || quantity == '' )
			{
				quantity = 1;
			}
			if( typeof priceContent == 'undefined' || priceContent == '' )
			{
				priceContent = false;
			}
			else
			{
				var total = priceContent.replace(',','.').replace(' ','');
				total = quantity*total;
				total = this.numericFormating(total);
			}

			// Construct order form content
			var poduct = '';
			poduct += '<div class="row">';
			poduct += '<div class="col-xs-3"><img class="img-responsive" src="' + imgSrc + '"></div>';
			poduct += '<div class="col-xs-9">';
			poduct += '<h4 class="product-order-title">' + entryTitle + '</h4>';
			poduct += '<input type="hidden" id="input-modal-order-product" name="modal-order-product" value="' + entryTitle + '">';
			if( priceContent ) {
				poduct += '<div class="product-order-quantity"><input type="number" min="1" max="10000" step="1" value="' + quantity + '" id="input-modal-order-quantity" class="form-control input-sm" name="modal-order-quantity"></div>&nbsp;X';
			}
			poduct += '<div class="product-order-offer"><span class="product-order-price-label">' + priceLabel + '</span> <span class="product-order-price">' + priceValue + '</span> <span class="product-order-currency">' + priceCurrency + '</span></div>';
			poduct += '<input type="hidden" id="input-modal-order-price" name="modal-order-price" value="' + priceValue + ' ' + priceCurrency +'">';
			if( priceContent ) {
				poduct += '<div class="clearfix"></div><hr>';
				poduct += '<div class="product-order-offer text-success"><span class="product-order-price-label">' + priceTotalLabel + '</span> <span id="product-order-total-price" class="product-order-price">' + total + '</span> <span class="product-order-currency">' + priceCurrency + '</span></div>';
				poduct += '<input type="hidden" id="input-modal-order-total" name="modal-order-total" value="' + total + ' ' + priceCurrency +'">';
			}
			poduct += '</div><!-- \.col-xs-9 -->';
			poduct += '</div><!-- \.row -->';

			return poduct;
		},


		/**
		 * Order form actions
		 *
		 */
		orderFormActions: function()
		{
			var _this = this;

			$('body').on('change', '#input-modal-order-quantity', function() {
				// Get data
				var quantity = $('input[name=modal-order-quantity]').val();
				var priceContent = $('article#'+ _this.postId).find('.price-value').attr('content');
				var priceCurrency = $('article#'+ _this.postId).find('.price-currency').text();
				var total = priceContent.replace(',','.').replace(' ','');
				total = quantity*total;
				total = _this.numericFormating(total);
				// Write total price
				$('#product-order-total-price').html(total);
				$('#input-modal-order-total').val(total + ' ' + priceCurrency);
			});
		},


////////////////////////////// HELPERS //////////////////////////////


		/**
		 * Price numbers formatting.
		 *
		 * @argument price - Price value for formatting
		 * @argument dischargesSeparator - Separator digits of the number
		 * @argument decimalSeparator - Decimal separator
		 *
		 * @return string
		 */
		numericFormating: function(price, dischargesSeparator, decimalSeparator)
		{

			// Checking for thousands separator
			if (!dischargesSeparator)
			{
				dischargesSeparator = ' ';
			}

			// Checking for decimal separator
			if (!decimalSeparator)
			{
				decimalSeparator = ',';
			}

			var priceIncubator = price.toString();

			// Determining the length of the formatted
			var floatLength = priceIncubator.lastIndexOf('.');
			floatLength = (floatLength > -1) ? floatLength : priceIncubator.length;

			// Isolation of the temporary buffer
			var resultSet = priceIncubator.substring(floatLength);
			var counter = -1;
			var i = floatLength;

			for( i; i > 0; i-- )
			{
				counter++;
				if( (counter % 3) === 0 && i !== floatLength && ( price >= 0 || i > 1) )
				{
					resultSet = dischargesSeparator + resultSet;
				}
				resultSet = priceIncubator.charAt(i - 1) + resultSet;
			}

			resultSet = resultSet.replace('.', decimalSeparator);
			return resultSet;
		},



	};

})(jQuery);



$(document).ready(function() {
	$.contactForms.initEvents();
});