<?php
/**
 * Template Name: Лендинг
 * Template Post Type: page
 * 
 * Шаблон для отображения посадочной страницы.
 * Основной файл лендинга
 *
 * 
 *
 * Параметры дополнительных полей:
 *
 *
 * h1 - понимает метаполе, приоритетный
 * nohead - Флаг. Без заголовка слайда
 * nobody - Флаг. Без контента слайда
 * headind - тег заголовка (h1,h2,h3,h4,h5,h6)
 * image_orientation - ориентация изображения для полуслайда (left, right)
 * cover - выравнивание картинки фона
 * fullheight - флаг, слайд 100% по ширине
 *
 * static_form_header - ID статической контакной формы
 * static_form_content - ID статической контакной формы
 * static_wrap - список селекторов для обертки контактной формы
 * btn_ico - Иконка кнопки (селектор fontawesome)
 * btn_title - Текст кнопки
 * btn_class - Дополнительные селекторы для кнопки
 * btn_form_header - ID контакной формы (модальнае контактная форма) в заголовке слайда
 * btn_link_header - Адрес ссылки для кнопки
 * btn_form_content - ID контакной формы (модальнае контактная форма) в контентной части слайда
 * btn_link_content - Адрес ссылки для кнопки
 * pattern - флаг необходимости замтемнения фонового изображения
 * phones_header - Список телефонов строкой в заголовке
 * phones_content - Список телефонов строкой в контентной части
 *
 *
 * @author veselka.ua
 * @version 0.4
 *
 * @package veselka_ua/veselka_landing
 */

	// Хедер
	get_header('landing');

	// Получение идентификатора лендинга
	// Элементы лендинга привязаны к таксономии landing
	$landing_term = get_post_meta($post->ID, 'landing_term', true);
	// Не указан термин? ПО умолчанию главная страница.
	if( $landing_term == '' || term_exists( $landing_term, 'landing' ) ) {
		$landing_term = 'Home';
	}

?>

	<article id="landing-article" itemscope itemtype="http://schema.org/Article">

<?php

	$args = [
		'post_type'			=>	'landing-elements',
		'landing'			=>	$landing_term,
		'post_parent__in'	=>	[0],
		'posts_per_page'	=>	-1,
		'post_status'		=>	'publish',
		'orderby'			=>	'menu_order',
		'order'				=>	'ASC',
	];

	$landing_query = new WP_Query( $args );
	if ( $landing_query->have_posts() ) {

		// Функции для карусели основного слайда
		require_once LANDING_PATH . '/view/_slide_functions.php';

		// Цикл Вордпресс
		while ( $landing_query->have_posts() ) : $landing_query->the_post();
			$template = get_post_meta( $landing_query->post->ID, '_wp_page_template', true );
			// Идентификатор слайда
			$slide_id = 'slide-' . str_replace( ['.php','landing-'], '', $template );
			// Шаблон слайда
			include( LANDING_PATH . '/view/' . $template );
		endwhile;

	} // endif
	wp_reset_postdata();
?>


	</article><!-- #landing-article -->
</div><!-- #landing-wrap -->

<?php include( TEMPLATEPATH . '/view/footer/_closing_part.php' ); ?>