<?php
/**
 * Вывод карусели в первом слайде лендинга.
 * 
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/veselka_landing
 */

$slide = page_cover( $post->ID, true );
$slide_link = get_post_meta( $post->ID, 'slide_link', true );
$contact_form = get_post_meta( $post->ID, 'contact_form', true );

?>
		<!-- Carousel -->
		<div id="landing-main-slide" class="responsive-carousel full-height scroll-section">

			<div id="landing-main-carousel" class="owl-carousel full-height">

				<div class="<?php echo $slide['class']; ?>"<?php echo $slide['bg']; ?>>

				<?php if( (bool)$contact_form ) { ?>
				<a href="#<?php echo $contact_form; ?>-form" class="modal-show" data-target="#<?php echo $contact_form; ?>-form" data-toggle="modal" title="<?php echo seo_page_title($post->ID); ?>">
				<?php } elseif( (bool)$slide_link ) { ?>
				<a href="<?php echo $slide_link; ?>" title="<?php echo seo_page_title($post->ID); ?>">
				<?php } ?>

					<div class="container carousel-slide-content full-height">

						<div class="slide-description full-height">
							<span itemprop="name" class="landing-title primary-font"><?php echo seo_page_title($post->ID); ?></span>
							<?php
								if( $post->post_excerpt != '' ) {
							?>

							<span itemprop="description" class="main-slide-text primary-font hidden-xs">
								<?php echo $post->post_excerpt; ?>
							</span>
							<?php
								} // endif
							?>
							<?php
								if( $post->post_content != '' ) {
							?>

							<span itemprop="description" class="main-slide-text primary-font hidden-xs">
								<?php echo $post->post_content; ?>
							</span>
							<?php
								} // endif
							?>

						</div><!-- /.slide-description -->

					</div><!-- /.container -->

				<?php if( (bool)$contact_form || (bool)$slide_link ) { ?>
				</a>
				<?php } ?>

				</div><!-- /.cover-page -->

<?php
	$args = [
			'post_type'			=>	'landing-elements',
			'post_parent__in'	=>	[ $post->ID ],
			'post_status'		=>	'publish',
			'orderby'			=>	'menu_order',
			'order'				=>	'ASC',
	];
	$slider_query = new WP_Query( $args );
	if ( $slider_query->have_posts() ) {
		// Цикл Вордпресс
		while ( $slider_query->have_posts() ) : $slider_query->the_post();
		$slide = page_cover($post->ID, true);
		$slide_link = get_post_meta($post->ID, 'slide_link', true);
		$contact_form = get_post_meta( $post->ID, 'contact_form', true );
?>

				<div class="<?php echo $slide['class']; ?>"<?php echo $slide['bg']; ?>>

				<?php if( (bool)$contact_form ) { ?>
				<a href="#<?php echo $contact_form; ?>-form" class="modal-show" data-target="#<?php echo $contact_form; ?>-form" data-toggle="modal" title="<?php echo seo_page_title($post->ID); ?>">
				<?php } elseif( (bool)$slide_link ) { ?>
				<a href="<?php echo $slide_link; ?>" title="<?php echo seo_page_title($post->ID); ?>">
				<?php } ?>

					<div class="container carousel-slide-content full-height">

						<div class="slide-description full-height">
							<span itemprop="name" class="landing-title primary-font"><?php echo seo_page_title($child->ID); ?></span>
							<?php
								if( $slider_query->post->post_excerpt != '' ) {
							?>

							<span itemprop="description" class="main-slide-text primary-font hidden-xs">
								<?php echo $slider_query->post->post_excerpt; ?>
							</span>
							<?php
								} // endif
							?>
							<?php
								if( $slider_query->post->post_content != '' ) {
							?>

							<span itemprop="description" class="main-slide-text primary-font hidden-xs">
								<?php echo $slider_query->post->post_content; ?>
							</span>
							<?php
								} // endif
							?>

						</div><!-- /.slide-description -->

					</div><!-- /.container -->

				<?php if( (bool)$contact_form || (bool)$slide_link ) { ?>
				</a>
				<?php } ?>

				</div><!-- /.cover-page -->
<?php
		endwhile;
	} // endif
	wp_reset_postdata();
?>

			</div><!-- /#landing-carousel -->
		</div><!-- /#landing-main-slide -->

<?php require_once LANDING_PATH . '/view/btn-scrolldown.php'; ?>
