<?php
/**
 * Слайд "Комментарии" в лендинге.
 * 
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/veselka_landing
 */

	// Заголовок слайда
	include( LANDING_PATH . '/view/_slide_header.php' );
?>


				<div id="comments-carousel" class="container responsive-carousel">
					<div class="owl-carousel">
<?php
	// Переопределение аргументов цикла по умолчанию
	$args = array(
		'number' => 10,
		'orderby' => 'comment_date',
		'order' => 'DESC',
		'status' => 'approve ',
		//'post_id' => 0,
		'type' => '', // только комментарии, без пингов и т.д...
	);

	if( $comments = get_comments( $args ) ){
		foreach( $comments as $comment ){
			$comm_link = get_comment_link( $comment->comment_ID ); // может быть тяжелый запрос ...
			$comm_short_txt = shorten( strip_tags( $comment->comment_content ), 35 ) .' ...';

			echo '<div class="text-info"><p class="lead"><a rel="nofollow" href="'. $comm_link .'"><i class="fa fa-comment"></i> '. $comm_short_txt .'</a></p><p><em><i class="fa fa-user"></i>&nbsp;'. $comment->comment_author .'</em></p></div>';
		}
	} // endif


	// Подвал слайда
	include( LANDING_PATH . '/view/_slide_footer.php' );

?>
