<?php
/**
 * Карта Гугл.
 *
 * Вывод маркера на основе публичной информации.
 * 
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_landing
 */
 */

$map_latitude = get_option('map_latitude');
$map_longitude = get_option('map_longitude');

$data = '';
if($map_latitude && map_latitude !='' && $map_longitude && $map_longitude !='' ) {
	// Координаты
	$data = ' data-lat="' . $map_latitude . '" data-lng="' . $map_longitude . '"';

	// Маркер
	$map_marker = get_option('map_marker');
	if( !$map_marker || $map_marker == '' ) {
		if( file_exists(TEMPLATEPATH . '/assets/img/ico/map_marker.png') ) {
			$map_marker = TEMPLATE_URL . '/assets/img/ico/map_marker.png';
		} elseif( file_exists(TEMPLATEPATH . '/assets/img/ico/favicon.png') ) {
			$map_marker = TEMPLATE_URL . '/assets/img/ico/favicon.png';
		}
	}
	if( $map_marker && $map_marker != '' ) {
		$data .= ' data-icon="' . $map_marker . '"';
	}

	// Зум
	$zoom = get_option('map_zoom');
	if( !$zoom || $zoom == '' ) {
		$zoom = 15;
	}
	$data .= ' data-zoom="' . $zoom . '"';

	// Email
	$public_email = get_option('public_email');
	if( $public_email && $public_email != '' ) {
		$data .= ' data-email="' . $public_email . '"';
	}

	// Телефон
	$phone_number = get_option('public_phone_number');
	$phone_sanitized = (string)str_replace(['+38','-','_','(',')',' '], '', $phone_number);
	if( $phone_sanitized && $phone_sanitized != '' ) {
		$data .= ' data-phone="' . $phone_sanitized . '"';
	}

	// Адрес
	$address = '';
	$poatal = get_option('public_poatal_code');
	if( $poatal && $poatal != '' ) {
		$address .= $poatal . ',';
	}
	$localization = get_option('public_localization');
	if( $localization && $localization != '' ) {
		$address .= ' ' . $localization . ',';
	}
	$street = get_option('public_address');
	if( $street && $street != '' ) {
		$address .= ' ' . $street . '';
	}
	if( $address && $address != '' ) {
		$data .= ' data-address="' . $address . '"';
	}

	// Часы работы
	$hours = get_option('public_business_hours');
	if( $hours && $hours != '' ) {
		$data .= ' data-hours="' . $hours . '"';
	}

	// Название
	$title = get_option('map_title');
	if( !$title && $title == '' ) {
		$title = get_option('blogname');
	}
	if( $title && $title != '' ) {
		$data .= ' data-title="' . $title . '"';
	}

	// Описание
	$description = get_option('map_description');
	if( !$description && $description == '' ) {
		$description = get_option('blogdescription');
	}
	if( $description && $description != '' ) {
		$data .= ' data-description="' . $description . '"';
	}

	if( is_page_template('page-template-landing.php') ) {
		$map_class = 'slide-footer slide-footer-contacts';
	} else {
		$map_class = 'slide-page-contacts scroll-section';
	}
?>
			<div id="map-contacts" class="<?php echo $map_class; ?>"<?php echo $data; ?>>

			</div><!-- /#map-contacts -->

<?php
}
?>