<?php
/**
 * Слайд "Наша команда" в лендинге
 * 
 */
$term = get_term_by('slug', 'our-team', 'category');
$meta = get_option( "taxonomy_{$term->term_id}" );
$slide_bg = '';
$slide_class = ' white-slide';
if( isset($meta['cat_thumb']) && $meta['cat_thumb'] != '' )  {
	$slide_bg = 'style="background-image: url(' . $meta['cat_thumb'] . ');" ';
	$slide_class = ' cover-page';
}

$remarka = '';
if( isset($meta['cat_rem']) && $meta['cat_rem'] != '' ) {
	$remarka = '<span>' . $meta['cat_rem'] . '</span>';
}
?>
			<div id="slide-our-team" class="landing-slide slave-slide<?php echo $slide_class; ?>" <?php echo $slide_bg; ?>>
				<div class="slide-heading">
					<div class="container">
						<h2><?php echo $term->name; ?></h2>
						<?php echo $remarka; ?>
					</div><!-- /.container -->
				</div>
				<div class="container">
					<div class="row">
<?php
	$args = array('post_type' => 'post', 'cat' => $term->term_id );
	$new_query = new WP_Query( $args );
	if ( $new_query->have_posts() ) {
		// Цикл Вордпресс
		while ( $new_query->have_posts() ) : $new_query->the_post();
			$img_url = wp_get_attachment_url( get_post_thumbnail_id($post->ID) );
			$position = get_post_meta($new_query->post->ID, 'position', true);
			if( !$position || $position == '' ) {
				$position = 'Стажер';
			}
?>
						<div class="col-xs-12 col-md-6 personel-card">
							<div class="col-sm-6">
								<img src="<?php echo $img_url; ?>" alt="<?php the_title(); ?>" class="img-circle img-responsive center-block">
							</div>
							<div class="col-sm-6 ">
								<h3><?php the_title(); ?></h3>
								<p class="personel-position text-primary"><?php echo $position; ?></p>
								<div class="personel-description">
									<?php the_content(); ?>
								</div>
							</div>
						</div>
<?php
		endwhile;
	} // endif
	wp_reset_postdata();
?>
					</div><!-- /.row -->
				</div><!-- /.container -->
			</div><!-- /#slide-our-team -->