<?php
/**
 * Работа с шаблонами
 *
 *
 * Добавляет пункты в выпадающий список
 * Сохраняет выбранный пункт меню
 * Отдает полный путь до шаблона страницы в плагине
 *
 *
 * @param void
 *
 * @author veselka.ua
 * @version 0.1
 *
 * @package veselka_ua/veselka_landing
 */


class LandingTemplater {

	/**
	 * Сущность экземпляра.
	 * @type obj
	 */
	private static $instance;

	/**
	 * Идентификатор текущей записи.
	 * @type array
	 */
	protected $post;

	/**
	 * Тип текущей записи.
	 * @type array
	 */
	protected $type;

	/**
	 * Шаблоны страниц.
	 * @type array
	 */
	protected $page = [];

	/**
	 * Шаблоны лендинга.
	 * @type array
	 */
	protected $landing_elements = [];


	/**
	 * Singletone.
	 *
	 * @param void
	 * @return obj
	 */
	public static function get_instance() {
		if( null == self::$instance ) {
			self::$instance = new LandingTemplater();
		}
		return self::$instance;
	}

	/**
	 * Инициализация.
	 *
	 * @param void
	 * @return void
	 */
	private function __construct() {

		// Добавляет пункт в выпадающем списке шаблонов страницы
		add_filter(
			'theme_page_templates', [ $this, 'add_new_template' ]
		);

		// Добавляет пункт в выпадающем списке шаблонов лендинга
		add_filter(
			'theme_landing-elements_templates', [ $this, 'add_new_template' ]
		);

		// Инъекция сохраняемого шаблона в кеш
		add_filter(
			'wp_insert_post_data', [ $this, 'register_project_templates' ] 
		);

		// Инъекция сохраняемого шаблона в кеш
		add_filter(
			'page_attributes_dropdown_pages_args', [ $this, 'register_project_templates' ] 
		);

		// Возвращает путь к шаблону из плагина если он сохранен в метаданных
		add_filter(
			'template_include', [ $this, 'view_project_template' ] 
		);
	}


	/**
	 * Инициализация
	 *
	 * @param void
	 * @return void
	 */
	private function load() {

		// Если уже записано
		if( !empty($this->page) ) {
			return NULL;
		}

		/**
		 * Стандартный путь к параметрам.
		 */
		require_once LANDING_PATH . '/conf/templates_list.php';

		// Объявление шаблонов
		$this->page = $page;
		$this->landing_elements = $landing_elements;
	}


	/**
	 * Добавляет шаблон в выпадающий список
	 *
	 * @param array
	 * @return array
	 */
	public function add_new_template( $posts_templates ) {

		$this->load();

		// Получение информации о записи
		global $post;
		if( isset($post) ) {
			$type = str_replace('-','_',$post->post_type);
			if( isset($this->{$type}) && !empty($this->{$type}) ) {
				$posts_templates = array_merge( $posts_templates, $this->{$type} );
			}
		}
		return $posts_templates;
	}


	/**
	 * Добавляет запись файла в кеш вордпресс. В итоге система управления думает, что файл на самом деле есть.
	 *
	 *
	 * !!! BUG !!!
	 * В списке страниц при выборе шаблона, подменяемая страница не выбирается, только если войти в страницу.
	 *
	 *
	 * @param array
	 * @return array
	 */
	public function register_project_templates( $atts ) {

		$this->load();

		// Нет guid? Ничего не делать.
		if( !isset($atts['guid']) ) {
			return $atts;
		}
		// Идентификатор
		$id = explode('=',$atts['guid']);
		$id=(int)$id[1];

		// Нет записи? Ничего не делать.
		if( !isset($this->{$atts['post_type']}) || !isset($id) || $id == 0 ) {
			return $atts;
		}

		// Ключ шаблона для хранения в кеше
		$cache_key = 'page_templates-' . md5( get_theme_root() . '/' . get_stylesheet() );

		// Восстановление списка шаблонов из кеша
		$templates = wp_get_theme()->get_page_templates( $id, $atts['post_type'] );
		//$templates = wp_cache_get( $cache_key, 'themes' );
		if( empty( $templates ) ) {
			$templates = [];
		}

		// Удаления кеша вордпресс
		wp_cache_delete( $cache_key , 'themes');

		// Соединение шаблона со списком из кеша
		$templates = array_merge( $templates, $this->{$atts['post_type']} );

		// Запись подмены с фейковым шаблоном в кеш
		wp_cache_add( $cache_key, $templates, 'themes', 1800 );

		return $atts;

	}


	/**
	 * Вывод пути к шаблону.
	 *
	 * @param array
	 * @return array
	 */
	public function view_project_template( $template ) {

		// Нет сущности записи, возвращаем стандартный шаблон
		global $post;
		if( !isset($post) ) {
			return $template;
		}

		$this->load();

		// Получение имени шаблона
		$file = get_post_meta( $post->ID, '_wp_page_template', true );

		// В случае отсутствия записи о файле, возвращаем стандартный шаблон
		if( !isset($file) || $file == '' || $file == 'default' ) {
			return $template;
		}

		// Полный путь к шаблону
		$file = LANDING_PATH . '/view/' . $file;

		// Для перестраховки, проверим наличие файла, в противном случае возвращается стандатный шаблон
		if( file_exists( $file ) ) {
			return $file;
		}

		return $template;

	}

} // end LandingTemplater


?>